/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.Session;

public class SessionLogEntry
implements Serializable {
    private static final String EMPTY_MESSAGE = "";
    @Deprecated(forRemoval=true)
    protected Date date;
    @Deprecated(forRemoval=true, since="4.0.9")
    protected transient Session session;
    private String sessionId;
    protected transient Thread thread;
    @Deprecated(forRemoval=true, since="4.0.9")
    protected transient Accessor connection;
    private final Integer connectionId;
    protected String message;
    protected Throwable throwable;
    protected int level;
    protected String nameSpace;
    protected Object[] parameters;
    protected boolean shouldTranslate;
    protected String sourceClassName;
    protected String sourceMethodName;
    private Instant timeStamp;

    private SessionLogEntry(int level, String nameSpace, String sessionId, String message, Object[] parameters, Integer connectionId, boolean shouldTranslate, Throwable throwable) {
        this.sessionId = sessionId;
        this.thread = Thread.currentThread();
        this.connectionId = connectionId;
        this.message = message != null ? message : EMPTY_MESSAGE;
        this.throwable = throwable;
        this.level = level;
        this.nameSpace = nameSpace;
        this.parameters = parameters;
        this.shouldTranslate = shouldTranslate;
        this.sourceClassName = null;
        this.sourceMethodName = null;
        this.timeStamp = Instant.now();
        this.date = new Date();
        this.session = null;
        this.connection = null;
    }

    public SessionLogEntry(int level, String category, String sessionId, String message, Object[] params, Integer connectionId, boolean shouldTranslate) {
        this(level, category, sessionId, message, params, connectionId, shouldTranslate, null);
    }

    public SessionLogEntry(int level, String category, String sessionId, String message, Throwable throwable) {
        this(level, category, sessionId, message, null, null, false, throwable);
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public SessionLogEntry(Session session) {
        this(5, null, session != null ? session.getSessionId() : null, EMPTY_MESSAGE, null);
        this.session = session;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public SessionLogEntry(Session session, Throwable throwable) {
        this(7, null, session != null ? session.getSessionId() : null, EMPTY_MESSAGE, throwable);
        this.session = session;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public SessionLogEntry(Session session, String message) {
        this(5, null, session != null ? session.getSessionId() : null, message, null);
        this.session = session;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public SessionLogEntry(Session session, String message, Accessor connection) {
        this(5, null, session != null ? session.getSessionId() : null, message, null, connection != null ? Integer.valueOf(connection.getConnectionId()) : null, false);
        this.session = session;
        this.connection = connection;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public SessionLogEntry(int level, Session session, String message, Object[] params, Accessor connection, boolean shouldTranslate) {
        this(level, null, session != null ? session.getSessionId() : null, message, params, connection != null ? Integer.valueOf(connection.getConnectionId()) : null, shouldTranslate, null);
        this.session = session;
        this.connection = connection;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public SessionLogEntry(int level, String category, Session session, String message, Object[] params, Accessor connection, boolean shouldTranslate) {
        this(level, category, session != null ? session.getSessionId() : null, message, params, connection != null ? Integer.valueOf(connection.getConnectionId()) : null, shouldTranslate, null);
        this.session = session;
        this.connection = connection;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public SessionLogEntry(Session session, int level, String category, Throwable throwable) {
        this(level, category, session != null ? session.getSessionId() : null, EMPTY_MESSAGE, throwable);
        this.session = session;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public Accessor getConnection() {
        return this.connection;
    }

    public Integer getConnectionId() {
        return this.connectionId;
    }

    @Deprecated(forRemoval=true)
    public Date getDate() {
        return this.date;
    }

    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    public Throwable getException() {
        return this.throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public Session getSession() {
        return this.session;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getLevel() {
        return this.level;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public String getSourceMethodName() {
        return this.sourceMethodName;
    }

    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public boolean hasMessage() {
        return this.getMessage() != null && !this.getMessage().isEmpty();
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void setConnection(Accessor connection) {
        this.connection = connection;
    }

    @Deprecated(forRemoval=true)
    public void setDate(Date date) {
        this.date = date;
    }

    public void setTimeStamp(Instant timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setException(Throwable throwable) {
        this.throwable = throwable;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public void setSession(Session session) {
        this.session = session;
        this.sessionId = session != null ? session.getSessionId() : null;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public void setParameters(Object[] params) {
        this.parameters = params;
    }

    public void setShouldTranslate(boolean shouldTranslate) {
        this.shouldTranslate = shouldTranslate;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    public void setSourceMethodName(String sourceMethodName) {
        this.sourceMethodName = sourceMethodName;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getMessage() + ")";
    }
}

