/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public abstract class MultiKeyIterate
extends MultiKeyOperation {
    private final Direction direction;
    private final int batchSize;
    private final byte[] resumeKey;

    MultiKeyIterate(InternalOperation.OpCode opCode, byte[] parentKey, KeyRange subRange, Depth depth, Direction direction, int batchSize, byte[] resumeKey) {
        super(opCode, parentKey, subRange, depth);
        ObjectUtil.checkNull("direction", direction);
        this.direction = direction;
        this.batchSize = batchSize;
        this.resumeKey = resumeKey;
    }

    MultiKeyIterate(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.direction = Direction.readFastExternal(in, serialVersion);
        this.batchSize = in.readInt();
        this.resumeKey = SerializationUtil.readByteArrayOldShortLength(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.direction.writeFastExternal(out, serialVersion);
        out.writeInt(this.batchSize);
        SerializationUtil.writeByteArrayOldShortLength(out, serialVersion, this.resumeKey);
    }

    Direction getDirection() {
        return this.direction;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    byte[] getResumeKey() {
        return this.resumeKey;
    }
}

