/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.ResourceLimitException;
import oracle.kv.impl.util.SerializationUtil;

public class IndexKeySizeLimitException
extends ResourceLimitException {
    private static final long serialVersionUID = 1L;
    private final String indexName;
    private final int indexKeySizeLimit;

    public IndexKeySizeLimitException(String tableName, String indexName, int indexKeySizeLimit, String msg) {
        super(tableName, msg);
        assert (tableName != null);
        assert (indexName != null);
        this.indexName = indexName;
        this.indexKeySizeLimit = indexKeySizeLimit;
    }

    public IndexKeySizeLimitException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.indexName = SerializationUtil.readString(in, serialVersion);
        this.indexKeySizeLimit = SerializationUtil.readPackedInt(in);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getIndexKeySizeLimit() {
        return this.indexKeySizeLimit;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeString(out, serialVersion, this.indexName);
        SerializationUtil.writePackedInt(out, this.indexKeySizeLimit);
    }
}

