/*
 * Decompiled with CFR 0.152.
 */
package com.mycorp.examples.timeservice.internal.provider.rest.consumer;

import com.mycorp.examples.timeservice.ITimeService;
import java.io.NotSerializableException;
import java.util.Map;
import java.util.UUID;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.IRemoteResponseDeserializer;
import org.eclipse.ecf.remoteservice.rest.RestCallableFactory;
import org.eclipse.ecf.remoteservice.rest.client.AbstractRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpGetRequestType;
import org.eclipse.ecf.remoteservice.rest.client.RestClientContainer;
import org.eclipse.ecf.remoteservice.rest.identity.RestID;
import org.json.JSONException;
import org.json.JSONObject;

public class TimeServiceRestClientContainer
extends RestClientContainer {
    public static final String TIMESERVICE_CONSUMER_CONFIG_NAME = "com.mycorp.examples.timeservice.rest.consumer";
    private IRemoteServiceRegistration reg;

    TimeServiceRestClientContainer() {
        super((RestID)IDFactory.getDefault().createID("com.mycorp.examples.timeservice.provider.rest.namespace", "uuid:" + UUID.randomUUID().toString()));
        this.setResponseDeserializer(new TimeServiceRestResponseDeserializer());
    }

    public void connect(ID targetID, IConnectContext connectContext1) throws ContainerConnectException {
        super.connect(targetID, connectContext1);
        IRemoteCallable callable = RestCallableFactory.createCallable((String)"getCurrentTime", (String)ITimeService.class.getName(), null, (AbstractRequestType)new HttpGetRequestType(), (long)30000L);
        this.reg = this.registerCallables(new String[]{ITimeService.class.getName()}, new IRemoteCallable[][]{{callable}}, null);
    }

    public void disconnect() {
        super.disconnect();
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName("com.mycorp.examples.timeservice.provider.rest.namespace");
    }

    class TimeServiceRestResponseDeserializer
    implements IRemoteResponseDeserializer {
        TimeServiceRestResponseDeserializer() {
        }

        public Object deserializeResponse(String endpoint, IRemoteCall call, IRemoteCallable callable, Map responseHeaders, byte[] responseBody) throws NotSerializableException {
            try {
                return new JSONObject(new String(responseBody)).get("time");
            }
            catch (JSONException e1) {
                throw new NotSerializableException(TimeServiceRestResponseDeserializer.class.getName());
            }
        }
    }
}

