/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;

public class Content {
    public static final Content NO_CONTENT = new Content(new byte[0], ContentType.DEFAULT_BINARY);
    private final byte[] raw;
    private final ContentType type;

    Content(byte[] raw, ContentType type) {
        this.raw = raw;
        this.type = type;
    }

    public ContentType getType() {
        return this.type;
    }

    public byte[] asBytes() {
        return (byte[])this.raw.clone();
    }

    public String asString() {
        Charset charset = this.type.getCharset();
        if (charset == null) {
            charset = HTTP.DEF_CONTENT_CHARSET;
        }
        try {
            return new String(this.raw, charset.name());
        }
        catch (UnsupportedEncodingException ex) {
            return new String(this.raw);
        }
    }

    public InputStream asStream() {
        return new ByteArrayInputStream(this.raw);
    }

    public String toString() {
        return this.asString();
    }
}

