/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.bittorrent.ui;

import java.io.File;
import java.io.IOException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.filetransfer.IFileTransfer;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.ui.FileTransfersView;
import org.eclipse.ecf.internal.provider.bittorrent.ui.BitTorrentConnectWizardPage;
import org.eclipse.ecf.internal.provider.bittorrent.ui.Messages;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.ecf.ui.dialogs.ContainerConnectErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

public class BitTorrentConnectWizard
extends Wizard
implements IConnectWizard,
INewWizard {
    private IWorkbench workbench;
    private BitTorrentConnectWizardPage page;
    private IContainer container;
    private IFileID targetID;
    private IWorkbenchPage workbenchPage;
    private String torrentFile;
    static /* synthetic */ Class class$0;

    public BitTorrentConnectWizard() {
    }

    public BitTorrentConnectWizard(String torrentFile) {
        this();
        this.torrentFile = torrentFile;
    }

    public void addPages() {
        this.page = new BitTorrentConnectWizardPage(this.torrentFile);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IContainer container) {
        this.workbench = workbench;
        this.container = container;
        this.setWindowTitle(Messages.getString("BitTorrentConnectWizardPage.File_Sharing.Title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.container = null;
        try {
            this.container = ContainerFactory.getDefault().createContainer("ecf.filetransfer.bittorrent");
        }
        catch (ContainerCreateException containerCreateException) {
            // empty catch block
        }
        this.setWindowTitle(Messages.getString("BitTorrentConnectWizardPage.File_Sharing.Title"));
    }

    public boolean performFinish() {
        this.workbenchPage = this.workbench.getActiveWorkbenchWindow().getActivePage();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IRetrieveFileTransferContainerAdapter irftca = (IRetrieveFileTransferContainerAdapter)this.container.getAdapter((Class)clazz);
        try {
            this.targetID = FileIDFactory.getDefault().createFileID(irftca.getRetrieveNamespace(), this.page.getTorrentName());
        }
        catch (FileCreateException e) {
            new ContainerConnectErrorDialog(this.workbench.getActiveWorkbenchWindow().getShell(), 1, "The target ID to connect to could not be created", this.page.getTorrentName(), (Throwable)e).open();
            return true;
        }
        try {
            irftca.sendRetrieveRequest(this.targetID, new IFileTransferListener(){

                public void handleTransferEvent(IFileTransferEvent e) {
                    FileTransfersView ftv;
                    if (e instanceof IIncomingFileTransferReceiveStartEvent) {
                        try {
                            IIncomingFileTransfer ift = ((IIncomingFileTransferReceiveStartEvent)e).receive(new File(BitTorrentConnectWizard.this.page.getTargetName()));
                            BitTorrentConnectWizard.this.workbenchPage.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(this, (IFileTransfer)ift){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ IFileTransfer val$ift;
                                {
                                    this.this$1 = var1_1;
                                    this.val$ift = iFileTransfer;
                                }

                                public void run() {
                                    FileTransfersView.addTransfer((IFileTransfer)this.val$ift);
                                }
                            });
                        }
                        catch (IOException ioe) {
                            new ContainerConnectErrorDialog(BitTorrentConnectWizard.this.workbench.getActiveWorkbenchWindow().getShell(), 1, "Could not write to " + BitTorrentConnectWizard.this.page.getTargetName(), BitTorrentConnectWizard.this.page.getTargetName(), null).open();
                        }
                    } else if (e instanceof IIncomingFileTransferEvent && (ftv = (FileTransfersView)BitTorrentConnectWizard.this.workbenchPage.findView("org.eclipse.ecf.filetransfer.ui.FileTransfersView")) != null) {
                        BitTorrentConnectWizard.this.workbenchPage.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(this, ftv, e){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ FileTransfersView val$ftv;
                            private final /* synthetic */ IFileTransferEvent val$e;
                            {
                                this.this$1 = var1_1;
                                this.val$ftv = fileTransfersView;
                                this.val$e = iFileTransferEvent;
                            }

                            public void run() {
                                this.val$ftv.update((IFileTransfer)((IIncomingFileTransferEvent)this.val$e).getSource());
                            }
                        });
                    }
                }
            }, null);
        }
        catch (IncomingFileTransferException e) {
            new ContainerConnectErrorDialog(this.workbench.getActiveWorkbenchWindow().getShell(), 1, "Could not send retrieval request.", this.targetID.getName(), (Throwable)e).open();
        }
        return true;
    }
}

