/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util.reflection;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class ClassUtil {
    private static Map convertor = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        convertor.put(Boolean.TYPE, clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        convertor.put(Byte.TYPE, clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        convertor.put(Character.TYPE, clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        convertor.put(Double.TYPE, clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        convertor.put(Float.TYPE, clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        convertor.put(Integer.TYPE, clazz6);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        convertor.put(Long.TYPE, clazz7);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        convertor.put(Short.TYPE, clazz8);
    }

    public static Method getMethod(Class aClass, String aMethodName, Class[] someParameterTypes) throws NoSuchMethodException {
        if (someParameterTypes == null || someParameterTypes.length == 0) {
            return aClass.getMethod(aMethodName, null);
        }
        return ClassUtil.getMethod(aClass.getMethods(), aMethodName, someParameterTypes);
    }

    public static Method getDeclaredMethod(Class aClass, String aMethodName, Class[] someParameterTypes) throws NoSuchMethodException {
        if (someParameterTypes == null || someParameterTypes.length == 0) {
            return aClass.getDeclaredMethod(aMethodName, null);
        }
        return ClassUtil.getMethod(aClass.getDeclaredMethods(), aMethodName, someParameterTypes);
    }

    private static Method getMethod(Method[] candidates, String aMethodName, Class[] someParameterTypes) throws NoSuchMethodException {
        int parameterCount = someParameterTypes.length;
        aMethodName = aMethodName.intern();
        TreeSet<Method> matches = new TreeSet<Method>(new MethodComparator(someParameterTypes));
        int i = 0;
        while (i < candidates.length) {
            block5: {
                Method candidate = candidates[i];
                String candidateMethodName = candidate.getName().intern();
                Class<?>[] candidateParameterTypes = candidate.getParameterTypes();
                int candidateParameterCount = candidateParameterTypes.length;
                if (candidateParameterCount == parameterCount && aMethodName == candidateMethodName) {
                    int j = 0;
                    while (j < candidateParameterCount) {
                        Class<?> clazzA = candidateParameterTypes[j];
                        Class clazzB = someParameterTypes[j];
                        if (clazzB == null || ClassUtil.isAssignableFrom(clazzA, clazzB)) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    matches.add(candidate);
                }
            }
            ++i;
        }
        if (matches.size() == 0) {
            throw new NoSuchMethodException("No such method: " + aMethodName + "(" + Arrays.asList(someParameterTypes) + ")");
        }
        return (Method)matches.first();
    }

    private static boolean isAssignableFrom(Class clazzA, Class clazzB) {
        if (!(clazzA.isPrimitive() ^ clazzB.isPrimitive())) {
            return clazzA.isAssignableFrom(clazzB);
        }
        if (clazzA.isPrimitive()) {
            Class oClazzA = (Class)convertor.get(clazzA);
            return oClazzA.isAssignableFrom(clazzB);
        }
        Class oClazzB = (Class)convertor.get(clazzB);
        return clazzA.isAssignableFrom(oClazzB);
    }

    private static class MethodComparator
    implements Comparator {
        private final Class[] parameterTypes;

        public MethodComparator(Class[] someParameterTypes) {
            this.parameterTypes = someParameterTypes;
        }

        public int compare(Object object1, Object object2) {
            Object[] pt2;
            Object[] pt1 = ((Method)object1).getParameterTypes();
            if (Arrays.equals(pt1, pt2 = ((Method)object2).getParameterTypes())) {
                return 0;
            }
            if (Arrays.equals(this.parameterTypes, pt1)) {
                return -1;
            }
            return 1;
        }
    }
}

