/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainerGroup;
import org.eclipse.ecf.server.generic.app.Connector;
import org.eclipse.ecf.server.generic.app.NamedGroup;
import org.eclipse.ecf.server.generic.app.ServerConfigParser;

public class ServerStartup {
    static TCPServerSOContainerGroup[] serverGroups = null;
    static final String SERVER_FILE_NAME = "ServerStartup.xml";
    static List servers = new ArrayList();

    public ServerStartup() throws Exception {
        InputStream ins = this.getClass().getResourceAsStream(SERVER_FILE_NAME);
        if (ins != null) {
            this.createServers(ins);
        }
    }

    protected boolean isActive() {
        return servers.size() > 0;
    }

    public void dispose() {
        this.destroyServers();
    }

    protected synchronized void destroyServers() {
        Iterator i = servers.iterator();
        while (i.hasNext()) {
            TCPServerSOContainer s = (TCPServerSOContainer)i.next();
            if (s == null) continue;
            try {
                s.dispose();
            }
            catch (Exception e) {
                ClientPlugin.log("Exception destroying server " + s.getConfig().getID());
            }
        }
        servers.clear();
        if (serverGroups != null) {
            int i2 = 0;
            while (i2 < serverGroups.length) {
                serverGroups[i2].takeOffTheAir();
                ++i2;
            }
            serverGroups = null;
        }
    }

    protected synchronized void createServers(InputStream ins) throws Exception {
        ServerConfigParser scp = new ServerConfigParser();
        List connectors = scp.load(ins);
        if (connectors != null) {
            serverGroups = new TCPServerSOContainerGroup[connectors.size()];
            int j = 0;
            Iterator i = connectors.iterator();
            while (i.hasNext()) {
                Connector connect = (Connector)i.next();
                ServerStartup.serverGroups[j] = this.createServerGroup(connect.getHostname(), connect.getPort());
                List groups = connect.getGroups();
                Iterator g = groups.iterator();
                while (g.hasNext()) {
                    NamedGroup group = (NamedGroup)g.next();
                    TCPServerSOContainer cont = this.createServerContainer(group.getIDForGroup(), serverGroups[j], group.getName(), connect.getTimeout());
                    servers.add(cont);
                    ClientPlugin.log("ECF group server created: " + cont.getConfig().getID().getName());
                }
                serverGroups[j].putOnTheAir();
                ++j;
            }
        }
    }

    protected TCPServerSOContainerGroup createServerGroup(String name, int port) {
        TCPServerSOContainerGroup group = new TCPServerSOContainerGroup(name, port);
        return group;
    }

    protected TCPServerSOContainer createServerContainer(String id, TCPServerSOContainerGroup group, String path, int keepAlive) throws IDCreateException {
        ID newServerID = IDFactory.getDefault().createStringID(id);
        SOContainerConfig config = new SOContainerConfig(newServerID);
        return new TCPServerSOContainer((ISharedObjectContainerConfig)config, group, path, keepAlive);
    }
}

