/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.Model;
import org.eclipse.modisco.java.discoverer.ElementsToAnalyze;
import org.eclipse.modisco.java.discoverer.internal.IModelReader;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;
import org.eclipse.modisco.java.discoverer.internal.Messages;
import org.eclipse.modisco.java.discoverer.internal.io.java.JavaReader;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.BindingManager;
import org.eclipse.modisco.java.discoverer.internal.io.library.LibraryReader;
import org.eclipse.modisco.java.emf.JavaFactory;
import org.eclipse.modisco.kdm.source.extension.discovery.AbstractRegionDiscoverer2;
import org.eclipse.modisco.kdm.source.extension.discovery.ISourceRegionNotifier;

public abstract class AbstractDiscoverJavaModelFromProject<T>
extends AbstractRegionDiscoverer2<T> {
    private ElementsToAnalyze fElementsToAnalyze;
    private boolean fLogJavaAnalysisWarnings = false;
    private boolean fDeepAnalysis = true;
    private boolean fIncrementalMode;
    private String includedElementsRegEx;
    private String excludedElementsRegEx;

    @Parameter(name="ELEMENTS_TO_ANALYZE", description="The Java projects or packages that will be analyzed. ")
    public void setElementsToAnalyze(ElementsToAnalyze elementsToAnalyze) {
        this.fElementsToAnalyze = elementsToAnalyze;
    }

    protected ElementsToAnalyze getElementsToAnalyze() {
        return this.fElementsToAnalyze;
    }

    @Parameter(name="LOG_JAVA_ANALYSIS_WARNINGS", description="Whether to log warnings from java analysis.")
    public void setLogJavaAnalysisWarnings(boolean logJavaAnalysisWarnings) {
        this.fLogJavaAnalysisWarnings = logJavaAnalysisWarnings;
    }

    protected boolean isLogJavaAnalysisWarnings() {
        return this.fLogJavaAnalysisWarnings;
    }

    @Parameter(name="DEEP_ANALYSIS", description="If true, analyze method bodies. If false, only analyze fields and method signatures.")
    public void setDeepAnalysis(boolean deepAnalysis) {
        this.fDeepAnalysis = deepAnalysis;
    }

    protected boolean isDeepAnalysis() {
        return this.fDeepAnalysis;
    }

    @Parameter(name="INCREMENTAL_MODE", description="Optimize memory use by analyzing incrementally (more time expensive).")
    public void setIncrementalMode(boolean incrementalMode) {
        this.fIncrementalMode = incrementalMode;
    }

    protected boolean isIncrementalMode() {
        return this.fIncrementalMode;
    }

    @Parameter(name="INCLUDED_ELEMENTS_REGEX", description="A regular expression on qualified names for elements (types & packages) to be included during analysis")
    public void setIncludedElementsRegEx(String includedElementsRegEx) {
        this.includedElementsRegEx = includedElementsRegEx;
    }

    protected String getIncludedElementsRegEx() {
        return this.includedElementsRegEx;
    }

    @Parameter(name="EXCLUDED_ELEMENTS_REGEX", description="A regular expression on qualified names for elements (types & packages) to be excluded during analysis")
    public void setExcludedElementsRegEx(String excludedElementsRegEx) {
        this.excludedElementsRegEx = excludedElementsRegEx;
    }

    protected String getExcludedElementsRegEx() {
        return this.excludedElementsRegEx;
    }

    public JavaFactory getEFactory() {
        return JavaFactory.eINSTANCE;
    }

    protected void analyzeJavaProject(IJavaProject source, IProgressMonitor monitor) throws DiscoveryException {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        IProject project = source.getProject();
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)project.getFullPath().append(project.getName()).toString().concat("_java.xmi"), (boolean)true));
        if (this.fElementsToAnalyze == null) {
            this.fElementsToAnalyze = new ElementsToAnalyze(source);
        }
        ElementsToAnalyze elementsToDiscover = AbstractDiscoverJavaModelFromProject.computeElementsToDiscover(this.fElementsToAnalyze);
        this.createTargetModel();
        Model model = this.getEFactory().createModel();
        BindingManager globalBindings = this.getBindingManager();
        this.getTargetModel().getContents().add((Object)model);
        IModelReader reader = null;
        for (Map.Entry<IModelReader, Object> readerEntry : this.getReaders(elementsToDiscover).entrySet()) {
            if (monitor.isCanceled()) {
                return;
            }
            reader = readerEntry.getKey();
            Object element = readerEntry.getValue();
            reader.readModel(element, model, globalBindings, monitor);
        }
        if (reader != null) {
            reader.terminate(monitor);
        }
        model.setName(project.getName());
        this.endAnalyzeJavaProject(model);
    }

    protected void endAnalyzeJavaProject(Model model) {
    }

    public static ElementsToAnalyze computeElementsToDiscover(ElementsToAnalyze userElementsToAnalyze) {
        try {
            IJavaProject javaProject = userElementsToAnalyze.getJavaProject();
            if (javaProject == null) {
                return userElementsToAnalyze.clone();
            }
            List<Object> discoverableElements = AbstractDiscoverJavaModelFromProject.computeDiscoverableElements(userElementsToAnalyze.getJavaProject());
            ElementsToAnalyze elementsToAnalyze = userElementsToAnalyze.clone();
            elementsToAnalyze.addElementToDiscover(javaProject);
            ArrayList<Object> elementsToRemove = new ArrayList<Object>();
            for (Object oldParameter : elementsToAnalyze.getElementsToDiscover()) {
                if (oldParameter.equals(javaProject) || discoverableElements.contains(oldParameter)) continue;
                elementsToRemove.add(oldParameter);
            }
            for (Object oldParameterToRemove : elementsToRemove) {
                elementsToAnalyze.removeElementToDiscover(oldParameterToRemove);
            }
            return elementsToAnalyze;
        }
        catch (CloneNotSupportedException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            return null;
        }
    }

    public static List<Object> computeDiscoverableElements(IJavaProject javaProject) {
        Set<IJavaProject> projects = null;
        Set<IPackageFragmentRoot> libraries = null;
        ArrayList<Object> discoverableElements = new ArrayList<Object>();
        try {
            projects = AbstractDiscoverJavaModelFromProject.computeRequiredProjects(javaProject);
            libraries = AbstractDiscoverJavaModelFromProject.computeRequiredLibraries(projects);
        }
        catch (JavaModelException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            return discoverableElements;
        }
        discoverableElements.addAll(projects);
        discoverableElements.addAll(libraries);
        return discoverableElements;
    }

    public String toString() {
        return Messages.DiscoverJavaModelFromJavaProject_title;
    }

    public static Set<IJavaProject> computeRequiredProjects(IJavaProject project) throws JavaModelException {
        LinkedHashSet<IJavaProject> projects = new LinkedHashSet<IJavaProject>();
        if (project == null) {
            return projects;
        }
        projects.add(project);
        String[] stringArray = project.getRequiredProjectNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            IJavaProject requiredProject = project.getJavaModel().getJavaProject(projectName);
            if (requiredProject.getProject().isAccessible()) {
                projects.add(requiredProject);
            }
            ++n2;
        }
        return projects;
    }

    protected static Set<IPackageFragmentRoot> computeRequiredLibraries(Collection<IJavaProject> projects) throws JavaModelException {
        LinkedHashSet<IPackageFragmentRoot> libraries = new LinkedHashSet<IPackageFragmentRoot>();
        for (IJavaProject project : projects) {
            libraries.addAll(AbstractDiscoverJavaModelFromProject.computeRequiredLibraries(project));
        }
        return libraries;
    }

    public static Set<IPackageFragmentRoot> computeRequiredLibraries(IJavaProject project) throws JavaModelException {
        LinkedHashSet<IPackageFragmentRoot> libraries = new LinkedHashSet<IPackageFragmentRoot>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot lib = iPackageFragmentRootArray[n2];
            if (lib.exists() && lib.getKind() == 2) {
                libraries.add(lib);
            }
            ++n2;
        }
        return libraries;
    }

    protected Map<IModelReader, Object> getReaders(ElementsToAnalyze elementsToDiscover) {
        HashMap<IModelReader, Object> readers = new HashMap<IModelReader, Object>();
        for (Object element : elementsToDiscover.getElementsToDiscover()) {
            Map<String, Object> elementOptions = elementsToDiscover.getDiscoveryOptions(element);
            if (element instanceof IJavaProject) {
                JavaReader javaReader = this.getJavaReader(elementOptions);
                javaReader.setIncremental(this.isIncrementalMode());
                javaReader.setDeepAnalysis(this.isDeepAnalysis());
                javaReader.setIncludedElementsRegEx(this.getIncludedElementsRegEx());
                javaReader.setExcludedElementsRegEx(this.getExcludedElementsRegEx());
                readers.put(javaReader, element);
                continue;
            }
            if (!(element instanceof IPackageFragmentRoot)) continue;
            LibraryReader libraryReader = this.getLibraryReader(elementOptions);
            readers.put(libraryReader, element);
        }
        return readers;
    }

    protected LibraryReader getLibraryReader(Map<String, Object> elementOptions) {
        return new LibraryReader(this.getEFactory(), elementOptions);
    }

    protected JavaReader getJavaReader(Map<String, Object> elementOptions) {
        return new JavaReader(this.getEFactory(), elementOptions, (ISourceRegionNotifier<?>)this);
    }

    protected BindingManager getBindingManager() {
        return new BindingManager(this.getEFactory());
    }
}

