/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.jsonrpc.ProtocolSince;

/**
 * Describes one or more type of breakpoint a `BreakpointMode` applies to.
 * This is a non-exhaustive enumeration and may expand as future breakpoint types are added.
 */
@ProtocolSince("1.65")
@SuppressWarnings("all")
public interface BreakpointModeApplicability {
  /**
   * In `SourceBreakpoint`s
   */
  static final String SOURCE = "source";

  /**
   * In exception breakpoints applied in the `ExceptionFilterOptions`
   */
  static final String EXCEPTION = "exception";

  /**
   * In data breakpoints requested in the `DataBreakpointInfo` request
   */
  static final String DATA = "data";

  /**
   * In `InstructionBreakpoint`s
   */
  static final String INSTRUCTION = "instruction";
}
