/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.util;

import com.overzealous.remark.util.MarkdownTable;

public class MarkdownTableCell {
    private MarkdownTable.Alignment alignment = MarkdownTable.Alignment.LEFT;
    private String contents = "";
    private int colspan = 1;

    public MarkdownTableCell() {
        this("", MarkdownTable.Alignment.LEFT, 1);
    }

    public MarkdownTableCell(String contents) {
        this(contents, MarkdownTable.Alignment.LEFT, 1);
    }

    public MarkdownTableCell(String contents, MarkdownTable.Alignment alignment) {
        this(contents, alignment, 1);
    }

    public MarkdownTableCell(String contents, int colspan) {
        this(contents, MarkdownTable.Alignment.LEFT, colspan);
    }

    public MarkdownTableCell(String contents, MarkdownTable.Alignment alignment, int colspan) {
        this.setContents(contents);
        this.setAlignment(alignment);
        this.setColspan(colspan);
    }

    public MarkdownTable.Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(MarkdownTable.Alignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException("Alignment cannot be null");
        }
        this.alignment = alignment;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        if (contents == null) {
            contents = "";
        }
        this.contents = contents.replace("\n", " ");
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int colspan) {
        if (colspan < 1) {
            colspan = 1;
        }
        this.colspan = colspan;
    }

    public int getWidth() {
        return this.contents.length() + 2;
    }

    public String toString() {
        return "MarkdownTableCell{colspan=" + this.colspan + ", alignment=" + (Object)((Object)this.alignment) + ", contents='" + this.contents + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkdownTableCell that = (MarkdownTableCell)o;
        return this.colspan == that.colspan && this.alignment == that.alignment && this.contents.equals(that.contents);
    }

    public int hashCode() {
        int result = this.alignment.hashCode();
        result = 31 * result + this.contents.hashCode();
        result = 31 * result + this.colspan;
        return result;
    }
}

