/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.xml;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.assertj.core.util.Preconditions;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

@Deprecated
public class XmlStringPrettyFormatter {
    private static final String FORMAT_ERROR = "Unable to format XML string";
    private static final Map<String, Boolean> SECURE_FEATURES = new HashMap<String, Boolean>();

    public static String xmlPrettyFormat(String xmlStringToFormat) {
        Preconditions.checkArgument(xmlStringToFormat != null, "Expecting XML String not to be null", new Object[0]);
        return XmlStringPrettyFormatter.prettyFormat(XmlStringPrettyFormatter.toXmlDocument(xmlStringToFormat), xmlStringToFormat.startsWith("<?xml"));
    }

    private static String prettyFormat(Document document, boolean keepXmlDeclaration) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            StringWriter stringWriter = new StringWriter();
            LSOutput formattedOutput = domImplementation.createLSOutput();
            formattedOutput.setCharacterStream(stringWriter);
            LSSerializer domSerializer = domImplementation.createLSSerializer();
            domSerializer.getDomConfig().setParameter("format-pretty-print", true);
            domSerializer.getDomConfig().setParameter("xml-declaration", keepXmlDeclaration);
            domSerializer.write(document, formattedOutput);
            return ((Object)stringWriter).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(FORMAT_ERROR, e);
        }
    }

    private static Document toXmlDocument(String xmlString) {
        try {
            InputSource xmlInputSource = new InputSource(new StringReader(xmlString));
            DocumentBuilder xmlDocumentBuilder = XmlStringPrettyFormatter.documentBuilderFactory().newDocumentBuilder();
            return xmlDocumentBuilder.parse(xmlInputSource);
        }
        catch (Exception e) {
            throw new RuntimeException(FORMAT_ERROR, e);
        }
    }

    private static DocumentBuilderFactory documentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        SECURE_FEATURES.forEach((name, value) -> {
            try {
                factory.setFeature((String)name, (boolean)value);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        });
        return factory;
    }

    private XmlStringPrettyFormatter() {
    }

    static {
        SECURE_FEATURES.put("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SECURE_FEATURES.put("http://apache.org/xml/features/disallow-doctype-decl", true);
        SECURE_FEATURES.put("http://xml.org/sax/features/external-general-entities", false);
        SECURE_FEATURES.put("http://xml.org/sax/features/external-parameter-entities", false);
        SECURE_FEATURES.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }
}

