/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.consoles;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.linuxtools.internal.docker.ui.consoles.StylerBuilder;

public class StyledTextBuilder {
    public static final char ESC = '\u001b';

    public static StyledString parse(String lineText) {
        StyledString result = new StyledString();
        Pattern colorSequencePattern = Pattern.compile("\\x1b\\[(?<colorcode>\\d{1,2})m(?<content>.*)");
        Matcher colorSequenceMatcher = colorSequencePattern.matcher(lineText);
        int lastColorSequencePosition = 0;
        int lastColorSequenceCode = 0;
        while (colorSequenceMatcher.find(lastColorSequencePosition)) {
            String inbetweenContent;
            int currentColorSequenceStartPosition = colorSequenceMatcher.start();
            String colorCode = colorSequenceMatcher.group("colorcode");
            if (lastColorSequencePosition < currentColorSequenceStartPosition && !(inbetweenContent = lineText.substring(lastColorSequencePosition, currentColorSequenceStartPosition)).isEmpty()) {
                result.append(inbetweenContent, StylerBuilder.styler(lastColorSequenceCode));
            }
            lastColorSequencePosition = currentColorSequenceStartPosition + ("\u001b[" + colorCode + "m").length();
            lastColorSequenceCode = Integer.parseInt(colorCode);
        }
        if (lastColorSequencePosition < lineText.length()) {
            String lastSequence = lineText.substring(lastColorSequencePosition);
            result.append(new StyledString(lastSequence, StylerBuilder.styler(lastColorSequenceCode)));
        }
        return result;
    }
}

