/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.burningwave.core.LoggingLevel;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;

public class SimpleManagedLoggerRepository
extends ManagedLogger.Repository.Abst {
    private Map<String, LoggingLevel.Mutable> loggers;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");

    public SimpleManagedLoggerRepository(Map<?, ?> properties) {
        super(properties);
    }

    @Override
    void initSpecificElements(Map<?, ?> properties) {
        this.loggers = new HashMap<String, LoggingLevel.Mutable>();
    }

    @Override
    void resetSpecificElements() {
        this.loggers.clear();
    }

    private LoggingLevel.Mutable getLoggerEnabledFlag(String clientName) {
        LoggingLevel.Mutable loggerEnabledFlag = this.loggers.get(clientName);
        if (loggerEnabledFlag == null) {
            loggerEnabledFlag = StaticComponentContainer.Synchronizer.execute(this.instanceId + "_" + clientName, () -> {
                LoggingLevel.Mutable loggerEnabledFlagTemp = this.loggers.get(clientName);
                if (loggerEnabledFlagTemp == null) {
                    loggerEnabledFlagTemp = new LoggingLevel.Mutable(31);
                    this.loggers.put(clientName, loggerEnabledFlagTemp);
                }
                return loggerEnabledFlagTemp;
            });
        }
        return loggerEnabledFlag;
    }

    @Override
    public void setLoggingLevelFlags(Class<?> cls, Integer flags) {
        this.getLoggerEnabledFlag(cls.getName()).set(flags);
    }

    @Override
    public Integer getLoggingLevelFlags(Class<?> cls) {
        return this.getLoggerEnabledFlag((String)cls.getName()).flags;
    }

    @Override
    public void addLoggingLevelFor(LoggingLevel logLevel, String ... classNames) {
        for (String className : classNames) {
            this.getLoggerEnabledFlag(className).add(logLevel.flags);
        }
    }

    @Override
    public void removeLoggingLevelFor(LoggingLevel logLevel, String ... classNames) {
        for (String className : classNames) {
            this.getLoggerEnabledFlag(className).remove(logLevel.flags);
        }
    }

    @Override
    public void setLoggingLevelFor(LoggingLevel logLevel, String ... classNames) {
        for (String className : classNames) {
            this.getLoggerEnabledFlag(className).set(logLevel.flags);
        }
    }

    private void setLoggerEnabledFlag(String client, LoggingLevel level) {
        this.loggers.put(client, new LoggingLevel.Mutable(level.flags));
    }

    private void log(Supplier<String> clientNameSupplier, LoggingLevel level, PrintStream printStream, String text, Throwable exception) {
        if (!this.isEnabled) {
            return;
        }
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[3].getClassName().equals(ManagedLogger.class.getName()) ? stackTraceElements[4] : stackTraceElements[3];
        String clientName = clientNameSupplier.get();
        if (this.getLoggerEnabledFlag(clientName).partialyMatch(level)) {
            if (exception == null) {
                printStream.println(this.dateFormat.format(new Date()) + " [" + Thread.currentThread().getName() + "] - " + clientName + " - " + this.addDetailsToMessage(text, stackTraceElement));
            } else {
                printStream.println(this.dateFormat.format(new Date()) + " [" + Thread.currentThread().getName() + "] - " + clientName + " - " + this.addDetailsToMessage(text, stackTraceElement));
                exception.printStackTrace(printStream);
            }
        }
    }

    @Override
    public void disableLogging(String clientName) {
        this.setLoggerEnabledFlag(clientName, new LoggingLevel.Mutable(0));
    }

    @Override
    public void enableLogging(String clientName) {
        this.setLoggerEnabledFlag(clientName, new LoggingLevel.Mutable(31));
    }

    @Override
    public void logError(Supplier<String> clientNameSupplier, Throwable exc) {
        this.log(clientNameSupplier, LoggingLevel.ERROR, System.err, "Exception occurred", exc);
    }

    @Override
    public void logError(Supplier<String> clientNameSupplier, String message, Throwable exc, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.ERROR, System.err, StaticComponentContainer.Strings.compile(message, arguments), exc);
    }

    @Override
    public void logError(Supplier<String> clientNameSupplier, String message, Throwable exc) {
        this.log(clientNameSupplier, LoggingLevel.ERROR, System.err, message, exc);
    }

    @Override
    public void logError(Supplier<String> clientNameSupplier, String message, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.ERROR, System.err, StaticComponentContainer.Strings.compile(message, arguments), null);
    }

    @Override
    public void logError(Supplier<String> clientNameSupplier, String message) {
        this.log(clientNameSupplier, LoggingLevel.ERROR, System.err, message, null);
    }

    @Override
    public void logDebug(Supplier<String> clientNameSupplier, String message) {
        this.log(clientNameSupplier, LoggingLevel.DEBUG, System.out, message, null);
    }

    @Override
    public void logDebug(Supplier<String> clientNameSupplier, String message, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.DEBUG, System.out, StaticComponentContainer.Strings.compile(message, arguments), null);
    }

    @Override
    public void logInfo(Supplier<String> clientNameSupplier, String message) {
        this.log(clientNameSupplier, LoggingLevel.INFO, System.out, message, null);
    }

    @Override
    public void logInfo(Supplier<String> clientNameSupplier, String message, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.INFO, System.out, StaticComponentContainer.Strings.compile(message, arguments), null);
    }

    @Override
    public void logWarn(Supplier<String> clientNameSupplier, String message) {
        this.log(clientNameSupplier, LoggingLevel.WARN, System.out, message, null);
    }

    @Override
    public void logWarn(Supplier<String> clientNameSupplier, String message, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.WARN, System.out, StaticComponentContainer.Strings.compile(message, arguments), null);
    }

    @Override
    public void logTrace(Supplier<String> clientNameSupplier, String message) {
        this.log(clientNameSupplier, LoggingLevel.TRACE, System.out, message, null);
    }

    @Override
    public void logTrace(Supplier<String> clientNameSupplier, String message, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.TRACE, System.out, StaticComponentContainer.Strings.compile(message, arguments), null);
    }

    @Override
    public void close() {
        this.loggers.clear();
        super.close();
    }
}

