/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.7")
public class ClassNamePatternFilterUtils {
    public static final String ALL_PATTERN = "*";
    public static final String BLANK = "";

    private ClassNamePatternFilterUtils() {
    }

    public static <T> Predicate<T> excludeMatchingClasses(@Nullable String patterns) {
        return ClassNamePatternFilterUtils.matchingClasses(patterns, object -> object.getClass().getName(), FilterType.EXCLUDE);
    }

    public static Predicate<String> excludeMatchingClassNames(@Nullable String patterns) {
        return ClassNamePatternFilterUtils.matchingClasses(patterns, Function.identity(), FilterType.EXCLUDE);
    }

    public static <T> Predicate<T> includeMatchingClasses(@Nullable String patterns) {
        return ClassNamePatternFilterUtils.matchingClasses(patterns, object -> object.getClass().getName(), FilterType.INCLUDE);
    }

    public static Predicate<String> includeMatchingClassNames(@Nullable String patterns) {
        return ClassNamePatternFilterUtils.matchingClasses(patterns, Function.identity(), FilterType.INCLUDE);
    }

    private static <T> Predicate<T> matchingClasses(@Nullable String patterns, Function<T, String> classNameProvider, FilterType type) {
        return Optional.ofNullable(patterns).filter(StringUtils::isNotBlank).map(String::strip).map(trimmedPatterns -> ClassNamePatternFilterUtils.createPredicateFromPatterns(trimmedPatterns, classNameProvider, type)).orElse(type == FilterType.EXCLUDE ? __ -> true : __ -> false);
    }

    private static <T> Predicate<T> createPredicateFromPatterns(String patterns, Function<T, String> classNameProvider, FilterType type) {
        if (ALL_PATTERN.equals(patterns)) {
            return type == FilterType.INCLUDE ? __ -> true : __ -> false;
        }
        List<Pattern> patternList = ClassNamePatternFilterUtils.convertToRegularExpressions(patterns);
        return object -> {
            boolean isMatchingAnyPattern = patternList.stream().anyMatch(pattern -> pattern.matcher((CharSequence)classNameProvider.apply(object)).matches());
            return type == FilterType.INCLUDE == isMatchingAnyPattern;
        };
    }

    private static List<Pattern> convertToRegularExpressions(String patterns) {
        return Arrays.stream(patterns.split(",")).filter(StringUtils::isNotBlank).map(String::strip).map(ClassNamePatternFilterUtils::replaceRegExElements).map(Pattern::compile).toList();
    }

    private static String replaceRegExElements(String pattern) {
        return Matcher.quoteReplacement(pattern).replace(".", "[.$]").replace(ALL_PATTERN, ".+");
    }

    private static enum FilterType {
        INCLUDE,
        EXCLUDE;

    }
}

