/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackSeries;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.model.IAxisDomain;
import org.eclipse.tracecompass.tmf.core.model.ISampling;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.genericxy.AbstractTreeGenericXYCommonXDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class CallStackFunctionDensityDataProvider
extends AbstractTreeGenericXYCommonXDataProvider<CallStackAnalysis, ITmfTreeDataModel> {
    public static final String ID = "org.eclipse.tracecompass.analysis.profiling.core.callstack.functiondensity.provider";
    private static final String EXECUTION_TIME = "Execution Time";
    private static final String NUMBER_OF_EXECUTIONS = "Number of Executions";
    private static final String UNIT_NS = "ns";
    private static final String UNIT_EMPTY = "";
    private final Map<Integer, Long> fPidsToEntryIds = new HashMap<Integer, Long>();
    private static final int UNKNOWN_PID = -1;
    private static final TmfXYAxisDescription Y_AXIS_DESCRIPTION = new TmfXYAxisDescription("Number of Executions", "", DataType.NUMBER);
    private Pair<Long, Long> fEndTimeToMaxDuration = null;

    public CallStackFunctionDensityDataProvider(@NonNull ITmfTrace trace, @NonNull CallStackAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    public TmfXYAxisDescription getXAxisDescription() {
        long maxDuration = this.getMaxExecutionTime();
        if (maxDuration == -1L) {
            return new TmfXYAxisDescription(EXECUTION_TIME, UNIT_NS, DataType.DURATION, (IAxisDomain)new IAxisDomain.Range(-1L, -1L));
        }
        return new TmfXYAxisDescription(EXECUTION_TIME, UNIT_NS, DataType.DURATION, (IAxisDomain)new IAxisDomain.Range(0L, maxDuration));
    }

    private long getMaxExecutionTime() {
        ITmfStateSystem ss = ((CallStackAnalysis)this.getAnalysisModule()).getStateSystem();
        if (ss == null) {
            return -1L;
        }
        if (this.fEndTimeToMaxDuration != null && ((Long)this.fEndTimeToMaxDuration.getFirst()).longValue() == ss.getCurrentEndTime()) {
            return (Long)this.fEndTimeToMaxDuration.getSecond();
        }
        CallStackSeries callstackSeries = ((CallStackAnalysis)this.getAnalysisModule()).getCallStackSeries();
        if (callstackSeries == null) {
            return -1L;
        }
        long maxDuration = -1L;
        for (ISegment segment : callstackSeries.getIntersectingElements(ss.getStartTime(), ss.getCurrentEndTime())) {
            maxDuration = Math.max(segment.getLength(), maxDuration);
        }
        this.fEndTimeToMaxDuration = new Pair((Object)ss.getCurrentEndTime(), (Object)maxDuration);
        return maxDuration;
    }

    public String getId() {
        return ID;
    }

    protected boolean isCacheable() {
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected TmfTreeModel<@NonNull ITmfTreeDataModel> getTree(@NonNull ITmfStateSystem ss, @NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        CallStackSeries series = ((CallStackAnalysis)this.getAnalysisModule()).getCallStackSeries();
        if (series == null) {
            return new TmfTreeModel(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<@NonNull TmfTreeDataModel> entries = new ArrayList<TmfTreeDataModel>();
        long traceId = this.getId(-1);
        entries.add(new TmfTreeDataModel(traceId, -1L, NonNullUtils.nullToEmptyString((Object)this.getTrace().getName())));
        @NonNull List processQuarks = ss.getQuarks(((CallStackAnalysis)this.getAnalysisModule()).getProcessesPattern());
        long end = ss.getCurrentEndTime();
        @NonNull List fullEnd = ss.queryFullState(end);
        for (Integer processQuark : processQuarks) {
            int pid = -1;
            if (processQuark != -1) {
                String processName = ss.getAttributeName(processQuark.intValue());
                Object processValue = ((ITmfStateInterval)fullEnd.get(processQuark)).getValue();
                pid = CallStackFunctionDensityDataProvider.getThreadProcessId(processName, processValue);
            }
            long entryId = this.getId(processQuark);
            this.fPidsToEntryIds.put(pid, entryId);
            entries.add(new TmfTreeDataModel(entryId, traceId, CallStackFunctionDensityDataProvider.getNameFromPID(pid)));
        }
        return new TmfTreeModel(Collections.emptyList(), entries);
    }

    private static @NonNull String getNameFromPID(int pid) {
        return pid == -1 ? "UNKNOWN_PID" : String.valueOf(pid);
    }

    private static int getThreadProcessId(String name, @Nullable Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable Pair<@NonNull ISampling, @NonNull Collection<@NonNull IYModel>> getXAxisAndYSeriesModels(@NonNull ITmfStateSystem ss, @NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        int pid;
        double[] bins;
        int nbSamples;
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQueryWithSamples(fetchParameters);
        if (filter == null) {
            return null;
        }
        CallStackSeries series = ((CallStackAnalysis)this.getAnalysisModule()).getCallStackSeries();
        if (series == null) {
            return null;
        }
        long sampleStart = 0L;
        long sampleEnd = this.getMaxExecutionTime();
        ISampling.Ranges sampling = CallStackFunctionDensityDataProvider.createEvenlyDistributedRanges(sampleStart, sampleEnd, nbSamples = filter.getNumberOfSamples());
        if (sampling == null) {
            return null;
        }
        @NonNull @NonNull List ranges = sampling.ranges();
        HashMap<Integer, double[]> pidsToBins = new HashMap<Integer, double[]>();
        @NonNull @NonNull Map selectedEntries = this.getSelectedEntries(filter);
        for (Map.Entry<Integer, Long> pidToEntryId : this.fPidsToEntryIds.entrySet()) {
            int pid2 = pidToEntryId.getKey();
            long entryId = pidToEntryId.getValue();
            if (!selectedEntries.containsKey(entryId)) continue;
            pidsToBins.put(pid2, new double[ranges.size()]);
        }
        long totalSpan = sampleEnd - sampleStart + 1L;
        long step = totalSpan / (long)nbSamples;
        for (ISegment segment : series.getIntersectingElements(filter.getStart(), filter.getEnd())) {
            ICalledFunction function;
            if (!(segment instanceof ICalledFunction) || (bins = (double[])pidsToBins.get(pid = (function = (ICalledFunction)segment).getProcessId())) == null) continue;
            long duration = segment.getLength();
            if (step <= 0L || duration < sampleStart || duration > sampleEnd) continue;
            int index = (int)((duration - sampleStart) / step);
            if (index >= nbSamples) {
                index = nbSamples - 1;
            }
            int n = index;
            bins[n] = bins[n] + 1.0;
        }
        ArrayList<@NonNull YModel> yModels = new ArrayList<YModel>();
        for (Map.Entry entry : pidsToBins.entrySet()) {
            pid = (Integer)entry.getKey();
            bins = (double[])entry.getValue();
            long entryId = this.fPidsToEntryIds.getOrDefault(pid, -1L);
            yModels.add(new YModel(entryId, CallStackFunctionDensityDataProvider.getNameFromPID(pid), bins, Y_AXIS_DESCRIPTION));
        }
        return new Pair((Object)sampling, yModels);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ISampling.Ranges createEvenlyDistributedRanges(long start, long end, int samples) {
        if (samples <= 0 || start >= end) {
            return null;
        }
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull @NonNull ISampling.Range> ranges = new ArrayList<ISampling.Range>(samples);
        long totalSpan = end - start;
        long step = totalSpan / (long)samples;
        long remainder = totalSpan % (long)samples;
        long current = start;
        int i = 0;
        while (i < samples) {
            long rangeStart = current;
            long rangeEnd = current + step - 1L;
            if (remainder > 0L) {
                ++rangeEnd;
                --remainder;
            }
            if (rangeEnd >= end || i == samples - 1) {
                rangeEnd = end;
            }
            ranges.add(new ISampling.Range((Comparable)Long.valueOf(rangeStart), (Comparable)Long.valueOf(rangeEnd)));
            current = rangeEnd + 1L;
            ++i;
        }
        return new ISampling.Ranges(ranges);
    }

    protected String getTitle() {
        String title = Objects.requireNonNull(Messages.CallStackFunctionDensityDataProviderFactory_title);
        return title;
    }
}

