/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Arrays;
import org.junit.jupiter.api.condition.AbstractOsBasedExecutionCondition;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.platform.commons.util.Preconditions;

class DisabledOnOsCondition
extends AbstractOsBasedExecutionCondition<DisabledOnOs> {
    DisabledOnOsCondition() {
        super(DisabledOnOs.class);
    }

    @Override
    ConditionEvaluationResult evaluateExecutionCondition(DisabledOnOs annotation) {
        boolean osSpecified = annotation.value().length > 0;
        boolean archSpecified = annotation.architectures().length > 0;
        Preconditions.condition((osSpecified || archSpecified ? 1 : 0) != 0, (String)"You must declare at least one OS or architecture in @DisabledOnOs");
        boolean enabled = this.isEnabledBasedOnOs(annotation) || this.isEnabledBasedOnArchitecture(annotation);
        String reason = this.createReason(enabled, osSpecified, archSpecified);
        return enabled ? ConditionEvaluationResult.enabled(reason) : ConditionEvaluationResult.disabled(reason, annotation.disabledReason());
    }

    private boolean isEnabledBasedOnOs(DisabledOnOs annotation) {
        OS[] operatingSystems = annotation.value();
        if (operatingSystems.length == 0) {
            return false;
        }
        return Arrays.stream(operatingSystems).noneMatch(OS::isCurrentOs);
    }

    private boolean isEnabledBasedOnArchitecture(DisabledOnOs annotation) {
        String[] architectures = annotation.architectures();
        if (architectures.length == 0) {
            return false;
        }
        return Arrays.stream(architectures).noneMatch(CURRENT_ARCHITECTURE::equalsIgnoreCase);
    }
}

