/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm;

import io.github.toolfactory.jvm.DefaultDriver;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplier;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.util.Map;

public class HybridDriver
extends DefaultDriver {
    @Override
    protected Map<Object, Object> functionsToMap() {
        Map<Object, Object> context = super.functionsToMap();
        ObjectProvider.get(context).markToBeInitializedViaExceptionHandler(ConsulterSupplier.class, context);
        ObjectProvider.get(context).markToBeInitializedViaExceptionHandler(ConsulterSupplyFunction.class, context);
        ObjectProvider.setExceptionHandler(context, new ObjectProvider.ExceptionHandler(){

            @Override
            public <T> T handle(ObjectProvider objectProvider, Class<? super T> clazz, Map<Object, Object> context, ObjectProvider.BuildingException exception) {
                if (objectProvider.isMarkedToBeInitializedViaExceptionHandler(exception)) {
                    if (clazz.isAssignableFrom(HybridDriver.this.getConsulterSupplierFunctionClass())) {
                        return (T)objectProvider.getOrBuildObject(HybridDriver.this.getConsulterSupplierFunctionClass(), context);
                    }
                    if (clazz.isAssignableFrom(HybridDriver.this.getConsulterSupplyFunctionClass())) {
                        return (T)objectProvider.getOrBuildObject(HybridDriver.this.getConsulterSupplyFunctionClass(), context);
                    }
                }
                throw exception;
            }
        });
        return context;
    }

    protected Class<? extends ConsulterSupplier> getConsulterSupplierFunctionClass() {
        return ConsulterSupplier.Hybrid.class;
    }

    @Override
    protected Class<? extends ConsulterSupplyFunction> getConsulterSupplyFunctionClass() {
        return ConsulterSupplyFunction.Hybrid.class;
    }
}

