/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class MatchArm
extends Statement {
    private final List<? extends Expression> conditions;
    private final Expression value;

    public MatchArm(int start, int end, List<? extends Expression> conditions, Expression value) {
        super(start, end);
        assert (value != null);
        this.conditions = conditions;
        this.value = value;
    }

    public MatchArm(int start, int end, Expression value) {
        this(start, end, null, value);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            if (this.conditions != null) {
                for (Expression expression : this.conditions) {
                    expression.traverse(visitor);
                }
            }
            this.value.traverse(visitor);
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 82;
    }

    public Collection<? extends Expression> getConditions() {
        return this.conditions;
    }

    public boolean isDefault() {
        return this.conditions == null;
    }

    public Expression getValue() {
        return this.value;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

