/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.breakpoints;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.debug.breakpoints.DSPLineBreakpoint;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class DSPBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IResource resource;
        ITextEditor textEditor = this.getEditor(part);
        if (textEditor != null && (resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class)) != null) {
            IBreakpoint[] breakpoints;
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine();
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.lsp4e.debug.model");
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof ILineBreakpoint) {
                    ILineBreakpoint lineBreakpoint = (ILineBreakpoint)breakpoint;
                    if (resource.equals((Object)breakpoint.getMarker().getResource()) && lineBreakpoint.getLineNumber() == lineNumber + 1) {
                        breakpoint.delete();
                        return;
                    }
                }
                ++n2;
            }
            DSPLineBreakpoint lineBreakpoint = new DSPLineBreakpoint(resource, lineNumber + 1);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    private @Nullable ITextEditor getEditor(IWorkbenchPart part) {
        MultiPageEditorPart multiPageEditorPart;
        Object object;
        if (part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            return textEditor;
        }
        if (part instanceof MultiPageEditorPart && (object = (multiPageEditorPart = (MultiPageEditorPart)part).getSelectedPage()) instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)object;
            return textEditor;
        }
        return null;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

