/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class CartesianProductIterator<E>
implements Iterator<List<E>> {
    private final List<Iterable<? extends E>> iterables;
    private final List<Iterator<? extends E>> iterators;
    private List<E> previousTuple;

    @SafeVarargs
    public CartesianProductIterator(Iterable<? extends E> ... iterables) {
        Objects.requireNonNull(iterables, "iterables");
        this.iterables = new ArrayList<Iterable<? extends E>>(iterables.length);
        this.iterators = new ArrayList<Iterator<? extends E>>(iterables.length);
        for (Iterable<E> iterable : iterables) {
            Objects.requireNonNull(iterable, "iterable");
            this.iterables.add(iterable);
            Iterator<E> iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                this.iterators.clear();
                break;
            }
            this.iterators.add(iterator);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterators.stream().anyMatch(Iterator::hasNext);
    }

    @Override
    public List<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.previousTuple == null) {
            this.previousTuple = new ArrayList(this.iterables.size());
            for (Iterator<E> iterator : this.iterators) {
                this.previousTuple.add(iterator.next());
            }
            return new ArrayList<E>(this.previousTuple);
        }
        for (int i = this.iterators.size() - 1; i >= 0; --i) {
            Iterator<E> iterator = this.iterators.get(i);
            if (iterator.hasNext()) {
                this.previousTuple.set(i, iterator.next());
                return new ArrayList<E>(this.previousTuple);
            }
            iterator = this.iterables.get(i).iterator();
            this.iterators.set(i, iterator);
            this.previousTuple.set(i, iterator.next());
        }
        throw new IllegalStateException("reached unreachable code");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

