/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.Attribute;
import org.eclipse.php.core.compiler.ast.nodes.IAttributed;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class PHPFieldDeclaration
extends FieldDeclaration
implements IPHPDocAwareDeclaration,
IAttributed {
    private SimpleReference fieldType;
    private int declStart;
    private Expression initializer;
    private PHPDocBlock phpDoc;
    private List<Attribute> attributes;

    public PHPFieldDeclaration(VariableReference variable, SimpleReference variableType, Expression initializer, int start, int end, int modifiers, int declStart, PHPDocBlock phpDoc) {
        super(variable.getName(), variable.sourceStart(), variable.sourceEnd(), start, end);
        if ((modifiers & 0x10) == 0 && (modifiers & 0x20) == 0) {
            modifiers |= 0x40;
        }
        this.setModifiers(modifiers);
        this.fieldType = variableType;
        this.initializer = initializer;
        this.declStart = declStart;
        this.phpDoc = phpDoc;
    }

    public PHPFieldDeclaration(VariableReference variable, Expression initializer, int start, int end, int modifiers, int declStart, PHPDocBlock phpDoc) {
        this(variable, null, initializer, start, end, modifiers, declStart, phpDoc);
    }

    @Override
    public PHPDocBlock getPHPDoc() {
        return this.phpDoc;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            if (this.attributes != null) {
                for (Attribute attr : this.attributes) {
                    attr.traverse(visitor);
                }
            }
            if (this.fieldType != null) {
                this.fieldType.traverse(visitor);
            }
            this.getRef().traverse(visitor);
            if (this.initializer != null) {
                this.initializer.traverse(visitor);
            }
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 25;
    }

    public Expression getVariableValue() {
        return this.initializer;
    }

    public int getDeclarationStart() {
        return this.declStart;
    }

    public SimpleReference getFieldType() {
        return this.fieldType;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public boolean isReadonly() {
        return (this.modifiers & 0x40000000) != 0;
    }

    @Override
    public void setPHPDoc(PHPDocBlock block) {
        this.phpDoc = block;
    }
}

