/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns;

import java.io.File;
import java.io.IOException;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.ImageUpdateAdapter;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.LabelProviderUpdateDaemon;

public class FileExtBasedImageUpdater
implements ImageUpdateAdapter {
    private LabelProviderUpdateDaemon updateDaemon;

    public FileExtBasedImageUpdater(LabelProviderUpdateDaemon daemon) {
        this.updateDaemon = daemon;
    }

    private String getFileExt(IFSTreeNode node) {
        String name = node.getName();
        String ext = "noext";
        int index = name.lastIndexOf(".");
        if (index != -1) {
            ext = name.substring(index + 1);
        }
        return ext;
    }

    private File getMirrorDir() {
        File tmpDir = this.updateDaemon.getTempDir();
        File mrrDir = new File(tmpDir, ".mrr");
        if (!mrrDir.exists() && !mrrDir.mkdirs()) {
            mrrDir = tmpDir;
        }
        return mrrDir;
    }

    @Override
    public String getImageKey(IFSTreeNode node) {
        String ext = this.getFileExt(node);
        return "EXT_IMAGE@" + ext;
    }

    @Override
    public File getMirrorFile(IFSTreeNode node) {
        String ext = this.getFileExt(node);
        File mrrDir = this.getMirrorDir();
        File file = new File(mrrDir, "mirror." + ext);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    @Override
    public File getImageFile(IFSTreeNode node) {
        String ext = this.getFileExt(node);
        return this.updateDaemon.getTempImg(ext);
    }
}

