/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MavenProblemResolution
extends WorkbenchMarkerResolution
implements ICompletionProposal,
ICompletionProposalExtension5 {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final IMarker marker;

    protected MavenProblemResolution(IMarker marker) {
        this.marker = marker;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected abstract void fix(IMarker[] var1, IDocument var2, IProgressMonitor var3);

    public boolean isSingleton() {
        return false;
    }

    public abstract boolean canFix(IMarker var1) throws CoreException;

    public Point getSelection(IDocument document) {
        return null;
    }

    public final String getDisplayString() {
        return this.getLabel();
    }

    public String getDescription() {
        return this.getLabel();
    }

    public String getAdditionalProposalInfo() {
        Object o = this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        return o == null ? null : o.toString();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.getDescription();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public final void run(IMarker marker) {
        this.run(marker, null);
    }

    public final void apply(IDocument document) {
        this.run(this.marker, document);
    }

    public final void run(IMarker[] markers, IProgressMonitor monitor) {
        this.fix(markers, null, monitor);
    }

    private void run(IMarker marker, IDocument document) {
        IMarker[] handledMarkers;
        if (this.isSingleton()) {
            try {
                IMarker[] allMarkers = ResourcesPlugin.getWorkspace().getRoot().findMarkers(null, true, 2);
                handledMarkers = this.findOtherMarkers(allMarkers, true);
            }
            catch (CoreException e) {
                handledMarkers = new IMarker[]{marker};
            }
        } else {
            handledMarkers = new IMarker[]{marker};
        }
        this.fix(handledMarkers, document, (IProgressMonitor)new NullProgressMonitor());
    }

    private IMarker[] findOtherMarkers(IMarker[] markers, boolean includeSelf) {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker != this.marker || includeSelf) {
                try {
                    if (this.canFix(marker)) {
                        result.add(marker);
                    }
                }
                catch (CoreException ex) {
                    this.LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
            ++n2;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    public final IMarker[] findOtherMarkers(IMarker[] markers) {
        return this.findOtherMarkers(markers, false);
    }

    public boolean includeResolution(List<? super IMarkerResolution> resolutions) {
        if (this.shouldBeAdded(resolutions)) {
            resolutions.add((IMarkerResolution)this);
            return true;
        }
        return false;
    }

    public boolean includeProposal(List<? super ICompletionProposal> proposals) {
        if (this.shouldBeAdded(proposals)) {
            proposals.add(this);
            return true;
        }
        return false;
    }

    private boolean shouldBeAdded(List<?> list) {
        if (this.isSingleton()) {
            for (Object o : list) {
                if (!o.getClass().equals(((Object)((Object)this)).getClass())) continue;
                return false;
            }
        }
        return true;
    }

    protected Set<IProject> getProjects(Stream<IMarker> markers) {
        return markers.map(m -> m.getResource().getProject()).collect(Collectors.toSet());
    }

    public static List<IMarkerResolution> getResolutions(IMarker marker) {
        IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
        List<IMarkerResolution> sortedResolutions = Arrays.asList(resolutions);
        Collections.sort(sortedResolutions, Comparator.comparingInt(MavenProblemResolution::getOrder).thenComparing(IMarkerResolution::getLabel));
        return sortedResolutions;
    }

    public static int getOrder(IMarkerResolution res) {
        if (res instanceof MavenProblemResolution var1_2) {
            return mr.getOrder();
        }
        return Integer.MAX_VALUE;
    }

    public static boolean hasResolutions(IMarker marker) {
        return IDE.getMarkerHelpRegistry().hasResolutions(marker);
    }
}

