/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.factory;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.FactoryCreationException;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;

public class FactoryDescriptor
extends Factory {
    public static final String ELEM = "factory";
    public static final String ATTR_PRODUCT_GROUP = "productGroup";
    public static final String ATTR_TYPE = "type";
    private static final String ATTR_CLASS = "class";
    private static final String ELEM_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private final IConfigurationElement configurationElement;

    public FactoryDescriptor(IConfigurationElement configurationElement) {
        super(FactoryDescriptor.createFactoryKey(configurationElement));
        this.configurationElement = configurationElement;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public IFactory createFactory() {
        try {
            IFactory factory;
            IFactoryKey key;
            IConfigurationElement element = this.configurationElement;
            String name = element.getName();
            if ("type".equals(name)) {
                element = (IConfigurationElement)element.getParent();
            }
            if ((key = (factory = (IFactory)element.createExecutableExtension(ATTR_CLASS)).getKey()) instanceof FactoryKey && key.getType() == null) {
                ((FactoryKey)key).setType(this.getType());
            }
            return factory;
        }
        catch (CoreException ex) {
            throw new FactoryCreationException(ex);
        }
    }

    @Override
    public Object create(String description) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDescriptionFor(Object product) {
        throw new UnsupportedOperationException();
    }

    private static FactoryKey createFactoryKey(IConfigurationElement element) {
        String name = element.getName();
        if (ELEM.equals(name)) {
            String productGroup = element.getAttribute(ATTR_PRODUCT_GROUP);
            String type = element.getAttribute("type");
            return new FactoryKey(productGroup, type);
        }
        if ("type".equals(name)) {
            IConfigurationElement parent = (IConfigurationElement)element.getParent();
            String productGroup = parent.getAttribute(ATTR_PRODUCT_GROUP);
            String value = element.getAttribute(ATTR_VALUE);
            return new FactoryKey(productGroup, value);
        }
        throw new IllegalStateException("Wrong configuration element: " + name);
    }
}

