/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl.attr.gen;

import ch.ethz.iks.slp.impl.attr.gen.ParserException;
import ch.ethz.iks.slp.impl.attr.gen.Rule;
import ch.ethz.iks.slp.impl.attr.gen.Visitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Pattern;

public class Parser {
    private String text;
    private int index = 0;
    private boolean trace = false;
    private int level = 0;
    private int error = -1;
    private Stack callStack = new Stack();
    private Stack errorStack = new Stack();
    private static final String newline = System.getProperty("line.separator", "\n");

    public static void main(String[] args) {
        boolean ok;
        Properties arguments = new Properties();
        String error = "";
        boolean bl = ok = args.length > 0;
        if (ok) {
            arguments.setProperty("Trace", "Off");
            arguments.setProperty("Rule", "attr-list");
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-trace")) {
                    arguments.setProperty("Trace", "On");
                } else if (args[i].equals("-visitor")) {
                    arguments.setProperty("Visitor", args[++i]);
                } else if (args[i].equals("-file")) {
                    arguments.setProperty("File", args[++i]);
                } else if (args[i].equals("-string")) {
                    arguments.setProperty("String", args[++i]);
                } else if (args[i].equals("-rule")) {
                    arguments.setProperty("Rule", args[++i]);
                } else {
                    error = "unknown argument: " + args[i];
                    ok = false;
                }
                ++i;
            }
        }
        if (ok && arguments.getProperty("File") == null && arguments.getProperty("String") == null) {
            error = "insufficient arguments: -file or -string required";
            ok = false;
        }
        if (!ok) {
            System.out.println("error: " + error);
            System.out.println("usage: Parser [-rule rulename] [-trace] <-file file | -string string> [-visitor visitor]");
        } else {
            try {
                Parser parser = new Parser();
                Rule rule = null;
                parser.traceOff();
                if (arguments.getProperty("Trace").equals("On")) {
                    parser.traceOn();
                }
                if (arguments.getProperty("File") != null) {
                    rule = parser.parse(arguments.getProperty("Rule"), new File(arguments.getProperty("File")));
                } else if (arguments.getProperty("String") != null) {
                    rule = parser.parse(arguments.getProperty("Rule"), arguments.getProperty("String"));
                }
                if (arguments.getProperty("Visitor") != null) {
                    Visitor visitor = (Visitor)Class.forName(arguments.getProperty("Visitor")).newInstance();
                    visitor.visit(rule);
                }
            }
            catch (IllegalArgumentException e) {
                System.out.println("argument error: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("io error: " + e.getMessage());
            }
            catch (ParserException e) {
                System.out.println("parser error: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                System.out.println("visitor error: class not found - " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                System.out.println("visitor error: illegal access - " + e.getMessage());
            }
            catch (InstantiationException e) {
                System.out.println("visitor error: instantiation failure - " + e.getMessage());
            }
        }
    }

    public Rule parse(String rulename, String string) throws IllegalArgumentException, ParserException {
        if (rulename == null) {
            throw new IllegalArgumentException("null rulename");
        }
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        return this.decode(rulename, string);
    }

    public Rule parse(String rulename, InputStream in) throws IllegalArgumentException, IOException, ParserException {
        if (rulename == null) {
            throw new IllegalArgumentException("null rulename");
        }
        if (in == null) {
            throw new IllegalArgumentException("null input stream");
        }
        int ch = 0;
        StringBuffer out = new StringBuffer();
        while ((ch = in.read()) != -1) {
            out.append((char)ch);
        }
        return this.decode(rulename, out.toString());
    }

    public Rule parse(String rulename, File file) throws IllegalArgumentException, IOException, ParserException {
        if (rulename == null) {
            throw new IllegalArgumentException("null rulename");
        }
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        BufferedReader in = new BufferedReader(new FileReader(file));
        int ch = 0;
        StringBuffer out = new StringBuffer();
        while ((ch = in.read()) != -1) {
            out.append((char)ch);
        }
        in.close();
        return this.decode(rulename, out.toString());
    }

    private void traceOn() {
        this.trace = true;
    }

    private void traceOff() {
        this.trace = false;
    }

    private void push(String function) {
        this.callStack.push(function);
        if (this.trace) {
            System.out.println("-> " + ++this.level + ": " + function + "()");
            System.out.println(String.valueOf(this.index) + ": " + this.text.substring(this.index, this.index + 10 > this.text.length() ? this.text.length() : this.index + 10).replaceAll("[^\\p{Print}]", " "));
        }
    }

    private void push(String function, String regex) {
        this.callStack.push(function);
        if (this.trace) {
            System.out.println("-> " + ++this.level + ": " + function + "(" + regex + ")");
            System.out.println(String.valueOf(this.index) + ": " + this.text.substring(this.index, this.index + 10 > this.text.length() ? this.text.length() : this.index + 10).replaceAll("[^\\p{Print}]", " "));
        }
    }

    private void push(String function, String spelling, String regex) {
        this.callStack.push(function);
        if (this.trace) {
            System.out.println("-> " + ++this.level + ": " + function + "(" + spelling + ", " + regex + ")");
            System.out.println(String.valueOf(this.index) + ": " + this.text.substring(this.index, this.index + 10 > this.text.length() ? this.text.length() : this.index + 10).replaceAll("[^\\p{Print}]", " "));
        }
    }

    private void pop(String function, boolean result, int length) {
        this.callStack.pop();
        if (this.trace) {
            System.out.println("<- " + this.level-- + ": " + function + "(" + (result ? "true," : "false,") + length + ")");
        }
        if (!result) {
            if (this.index > this.error) {
                this.error = this.index;
                this.errorStack = new Stack();
                this.errorStack.addAll(this.callStack);
            }
        } else if (this.index > this.error) {
            this.error = -1;
        }
    }

    private Rule decode(String rulename, String text) throws ParserException {
        this.text = text;
        Rule rule = null;
        if (rulename.equalsIgnoreCase("attr-list")) {
            rule = this.decode_attr_list();
        } else if (rulename.equalsIgnoreCase("attribute")) {
            rule = this.decode_attribute();
        } else if (rulename.equalsIgnoreCase("attr-val-list")) {
            rule = this.decode_attr_val_list();
        } else if (rulename.equalsIgnoreCase("attr-tag")) {
            rule = this.decode_attr_tag();
        } else if (rulename.equalsIgnoreCase("attr-val")) {
            rule = this.decode_attr_val();
        } else if (rulename.equalsIgnoreCase("intval")) {
            rule = this.decode_intval();
        } else if (rulename.equalsIgnoreCase("strval")) {
            rule = this.decode_strval();
        } else if (rulename.equalsIgnoreCase("boolval")) {
            rule = this.decode_boolval();
        } else if (rulename.equalsIgnoreCase("opaque")) {
            rule = this.decode_opaque();
        } else if (rulename.equalsIgnoreCase("safe-val")) {
            rule = this.decode_safe_val();
        } else if (rulename.equalsIgnoreCase("safe-tag")) {
            rule = this.decode_safe_tag();
        } else if (rulename.equalsIgnoreCase("escape-val")) {
            rule = this.decode_escape_val();
        } else if (rulename.equalsIgnoreCase("DIGIT")) {
            rule = this.decode_DIGIT();
        } else if (rulename.equalsIgnoreCase("HEXDIG")) {
            rule = this.decode_HEXDIG();
        } else {
            throw new IllegalArgumentException("unknown rule");
        }
        if (rule == null) {
            String marker = "                              ";
            StringBuffer errorBuffer = new StringBuffer();
            int start = this.error < 30 ? 0 : this.error - 30;
            int end = text.length() < this.error + 30 ? text.length() : this.error + 30;
            errorBuffer.append("rule \"" + (String)this.errorStack.peek() + "\" failed" + newline);
            errorBuffer.append(String.valueOf(text.substring(start, end).replaceAll("[^\\p{Print}]", " ")) + newline);
            errorBuffer.append(String.valueOf(marker.substring(0, this.error < 30 ? this.error : 30)) + "^" + newline);
            errorBuffer.append("rule stack:");
            Iterator i = this.errorStack.iterator();
            while (i.hasNext()) {
                errorBuffer.append(String.valueOf(newline) + "  " + (String)i.next());
            }
            throw new ParserException(errorBuffer.toString());
        }
        if (text.length() > this.index) {
            String marker = "                              ";
            StringBuffer errorBuffer = new StringBuffer();
            int start = this.index < 30 ? 0 : this.index - 30;
            int end = text.length() < this.index + 30 ? text.length() : this.index + 30;
            errorBuffer.append("extra data found" + newline);
            errorBuffer.append(String.valueOf(text.substring(start, end).replaceAll("[^\\p{Print}]", " ")) + newline);
            errorBuffer.append(String.valueOf(marker.substring(0, this.index < 30 ? this.index : 30)) + "^" + newline);
            throw new ParserException(errorBuffer.toString(), rule);
        }
        return rule;
    }

    private attr_list decode_attr_list() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<attr_list> e1;
        this.push("attr-list");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<attr_list>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_attribute();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_list)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue(",");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_list)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_attr_list();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_list)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_attribute();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_list)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new attr_list(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("attr-list", decoded, this.index - s0);
        return rule;
    }

    private attribute decode_attribute() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<attribute> e1;
        this.push("attribute");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<attribute>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("(");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attribute)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_attr_tag();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attribute)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("=");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attribute)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_attr_val_list();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attribute)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue(")");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attribute)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_attr_tag();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attribute)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new attribute(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("attribute", decoded, this.index - s0);
        return rule;
    }

    private attr_val_list decode_attr_val_list() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<attr_val_list> e1;
        this.push("attr-val-list");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<attr_val_list>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_attr_val();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_val_list)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue(",");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_val_list)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_attr_val_list();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_val_list)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_attr_val();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_val_list)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new attr_val_list(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("attr-val-list", decoded, this.index - s0);
        return rule;
    }

    private attr_tag decode_attr_tag() {
        Rule rule;
        this.push("attr-tag");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<attr_tag> e1 = new ArrayList<attr_tag>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                int i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_safe_tag();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_tag)rule);
                        ++c1;
                    }
                    ++i1;
                }
                while (f1) {
                    rule = this.decode_safe_tag();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((attr_tag)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 >= 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new attr_tag(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("attr-tag", decoded, this.index - s0);
        return rule;
    }

    private attr_val decode_attr_val() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<attr_val> e1;
        this.push("attr-val");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<attr_val>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_intval();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_strval();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_boolval();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_opaque();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((attr_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new attr_val(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("attr-val", decoded, this.index - s0);
        return rule;
    }

    private intval decode_intval() {
        Rule rule;
        this.push("intval");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<intval> e1 = new ArrayList<intval>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("-");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((intval)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_DIGIT();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((intval)rule);
                        ++c1;
                    }
                    ++i1;
                }
                while (f1) {
                    rule = this.decode_DIGIT();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((intval)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 >= 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new intval(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("intval", decoded, this.index - s0);
        return rule;
    }

    private strval decode_strval() {
        Rule rule;
        this.push("strval");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<strval> e1 = new ArrayList<strval>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                int i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_safe_val();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((strval)rule);
                        ++c1;
                    }
                    ++i1;
                }
                while (f1) {
                    rule = this.decode_safe_val();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((strval)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 >= 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new strval(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("strval", decoded, this.index - s0);
        return rule;
    }

    private boolval decode_boolval() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<boolval> e1;
        this.push("boolval");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<boolval>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("true");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((boolval)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("false");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((boolval)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new boolval(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("boolval", decoded, this.index - s0);
        return rule;
    }

    private opaque decode_opaque() {
        Rule rule;
        this.push("opaque");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<opaque> e1 = new ArrayList<opaque>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("\\FF");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((opaque)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_escape_val();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((opaque)rule);
                        ++c1;
                    }
                    ++i1;
                }
                while (f1) {
                    rule = this.decode_escape_val();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((opaque)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 >= 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new opaque(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("opaque", decoded, this.index - s0);
        return rule;
    }

    private safe_val decode_safe_val() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<safe_val> e1;
        this.push("safe-val");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<safe_val>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x20", "[\\x20]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x22-27", "[\\x22-\\x27]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x2A-2B", "[\\x2A-\\x2B]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x2D-3B", "[\\x2D-\\x3B]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x3F-5B", "[\\x3F-\\x5B]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x5D-7D", "[\\x5D-\\x7D]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new safe_val(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("safe-val", decoded, this.index - s0);
        return rule;
    }

    private safe_tag decode_safe_tag() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<safe_tag> e1;
        this.push("safe-tag");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<safe_tag>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x20", "[\\x20]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_tag)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x22-27", "[\\x22-\\x27]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_tag)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x2B", "[\\x2B]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_tag)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x2D-3B", "[\\x2D-\\x3B]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_tag)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x3F-5B", "[\\x3F-\\x5B]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_tag)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x5D-5E", "[\\x5D-\\x5E]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_tag)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x60-7D", "[\\x60-\\x7D]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((safe_tag)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new safe_tag(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("safe-tag", decoded, this.index - s0);
        return rule;
    }

    private escape_val decode_escape_val() {
        Rule rule;
        this.push("escape-val");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<escape_val> e1 = new ArrayList<escape_val>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("\\");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((escape_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_HEXDIG();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((escape_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_HEXDIG();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((escape_val)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new escape_val(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("escape-val", decoded, this.index - s0);
        return rule;
    }

    private DIGIT decode_DIGIT() {
        Rule rule;
        this.push("DIGIT");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<DIGIT> e1 = new ArrayList<DIGIT>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                int i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_NumericValue("%x30-39", "[\\x30-\\x39]", 1);
                    f1 = rule != null;
                    if (f1) {
                        e1.add((DIGIT)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new DIGIT(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("DIGIT", decoded, this.index - s0);
        return rule;
    }

    private HEXDIG decode_HEXDIG() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<DIGIT> e1;
        this.push("HEXDIG");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<DIGIT>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_DIGIT();
                    f1 = rule != null;
                    if (f1) {
                        e1.add((DIGIT)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("A");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((DIGIT)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("B");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((DIGIT)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("C");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((DIGIT)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("D");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((DIGIT)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("E");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((DIGIT)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                i1 = 0;
                while (i1 < 1 && f1) {
                    rule = this.decode_StringValue("F");
                    f1 = rule != null;
                    if (f1) {
                        e1.add((DIGIT)rule);
                        ++c1;
                    }
                    ++i1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new HEXDIG(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("HEXDIG", decoded, this.index - s0);
        return (HEXDIG)rule;
    }

    private StringValue decode_StringValue(String regex) {
        this.push("*StringValue", regex);
        boolean decoded = true;
        int start = this.index;
        StringValue stringValue = null;
        try {
            String value = this.text.substring(this.index, this.index + regex.length());
            decoded = value.equalsIgnoreCase(regex);
            if (decoded) {
                this.index += regex.length();
                stringValue = new StringValue(value, null);
            }
        }
        catch (IndexOutOfBoundsException e) {
            decoded = false;
        }
        this.pop("*StringValue", decoded, this.index - start);
        return stringValue;
    }

    private NumericValue decode_NumericValue(String spelling, String regex, int length) {
        this.push("*NumericValue", spelling, regex);
        boolean decoded = true;
        int start = this.index;
        NumericValue numericValue = null;
        try {
            String value = this.text.substring(this.index, this.index + length);
            decoded = Pattern.matches(regex, value);
            if (decoded) {
                this.index += length;
                numericValue = new NumericValue(value, null);
            }
        }
        catch (IndexOutOfBoundsException e) {
            decoded = false;
        }
        this.pop("*NumericValue", decoded, this.index - start);
        return numericValue;
    }

    public static final class DIGIT
    extends Rule {
        private DIGIT(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public DIGIT(DIGIT rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_DIGIT(this);
        }
    }

    public static final class HEXDIG
    extends Rule {
        private HEXDIG(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public HEXDIG(HEXDIG rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_HEXDIG(this);
        }
    }

    public class NumericValue
    extends Rule {
        public NumericValue(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_NumericValue(this);
        }
    }

    public class StringValue
    extends Rule {
        public StringValue(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_StringValue(this);
        }
    }

    public static final class attr_list
    extends Rule {
        private attr_list(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public attr_list(attr_list rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_attr_list(this);
        }
    }

    public static final class attr_tag
    extends Rule {
        private attr_tag(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public attr_tag(attr_tag rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_attr_tag(this);
        }
    }

    public static final class attr_val
    extends Rule {
        private attr_val(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public attr_val(attr_val rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_attr_val(this);
        }
    }

    public static final class attr_val_list
    extends Rule {
        private attr_val_list(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public attr_val_list(attr_val_list rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_attr_val_list(this);
        }
    }

    public static final class attribute
    extends Rule {
        private attribute(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public attribute(attribute rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_attribute(this);
        }
    }

    public static final class boolval
    extends Rule {
        private boolval(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public boolval(boolval rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_boolval(this);
        }
    }

    public static final class escape_val
    extends Rule {
        private escape_val(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public escape_val(escape_val rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_escape_val(this);
        }
    }

    public static final class intval
    extends Rule {
        private intval(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public intval(intval rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_intval(this);
        }
    }

    public static final class opaque
    extends Rule {
        private opaque(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public opaque(opaque rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_opaque(this);
        }
    }

    public static final class safe_tag
    extends Rule {
        private safe_tag(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public safe_tag(safe_tag rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_safe_tag(this);
        }
    }

    public static final class safe_val
    extends Rule {
        private safe_val(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public safe_val(safe_val rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_safe_val(this);
        }
    }

    public static final class strval
    extends Rule {
        private strval(String spelling, ArrayList rules) {
            super(spelling, rules);
        }

        public strval(strval rule) {
            super(rule.spelling, rule.rules);
        }

        public Object visit(Visitor visitor) {
            return visitor.visit_strval(this);
        }
    }
}

