/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.project;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.util.JUnitVersion;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtext.ui.internal.Activator;
import org.eclipse.xtext.xtext.ui.wizard.project.Messages;
import org.eclipse.xtext.xtext.ui.wizard.project.StatusWidget;
import org.eclipse.xtext.xtext.wizard.BuildSystem;
import org.eclipse.xtext.xtext.wizard.LanguageServer;
import org.eclipse.xtext.xtext.wizard.SourceLayout;
import org.osgi.framework.Bundle;

public class AdvancedNewProjectPage
extends WizardPage {
    private Button createUiProject;
    private Button createSDKProject;
    private Button createP2Project;
    private Button createWebProject;
    private Button createIdeProject;
    private Button createTestProject;
    private Button junitVersion4;
    private Button junitVersion5;
    private Combo preferredBuildSystem;
    private Combo createLanguageServer;
    private Combo sourceLayout;
    private Group createUiProjectSubGroup;
    private StatusWidget statusWidget;
    private boolean autoSelectIdeProject;
    private boolean autoSelectSDKProject;

    public AdvancedNewProjectPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.AdvancedNewProjectPage_WindowTitle);
        this.setDescription(Messages.AdvancedNewProjectPage_Description);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.Group(control, (Procedures.Procedure1<? super Group>)((Procedures.Procedure1)group -> {
            group.setText(Messages.AdvancedNewProjectPage_LabelFacets);
            this.createUiProject = this.CheckBox((Composite)group, (Procedures.Procedure1<? super Button>)((Procedures.Procedure1)button -> button.setText(Messages.AdvancedNewProjectPage_projEclipse)));
            this.createUiProjectSubGroup = this.Group((Composite)group, (Procedures.Procedure1<? super Group>)((Procedures.Procedure1)subGroup -> {
                this.createSDKProject = this.CheckBox((Composite)subGroup, (Procedures.Procedure1<? super Button>)((Procedures.Procedure1)button -> button.setText(Messages.AdvancedNewProjectPage_projEclipseSDKFeature)));
                this.createP2Project = this.CheckBox((Composite)subGroup, (Procedures.Procedure1<? super Button>)((Procedures.Procedure1)button -> button.setText(Messages.AdvancedNewProjectPage_projEclipseP2)));
            }));
            this.createWebProject = this.CheckBox((Composite)group, (Procedures.Procedure1<? super Button>)((Procedures.Procedure1)button -> {
                button.setText(Messages.AdvancedNewProjectPage_projWeb);
                button.setEnabled(true);
            }));
            this.createIdeProject = this.CheckBox((Composite)group, (Procedures.Procedure1<? super Button>)((Procedures.Procedure1)button -> {
                button.setText(Messages.AdvancedNewProjectPage_projIde);
                button.setEnabled(false);
                this.InfoDecoration((Control)button, Messages.AdvancedNewProjectPage_projIde_description);
                button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
            }));
            Composite childComposite = new Composite((Composite)group, 0);
            GridLayout layout = new GridLayout(4, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            childComposite.setLayout((Layout)layout);
            this.createTestProject = this.CheckBox(childComposite, (Procedures.Procedure1<? super Button>)((Procedures.Procedure1)button -> {
                button.setText(Messages.WizardNewXtextProjectCreationPage_TestingSupport);
                button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            }));
            Label label = new Label(childComposite, 16384);
            label.setText(Messages.AdvancedNewProjectPage_junitVersion);
            this.junitVersion4 = this.Radio(childComposite, (Procedures.Procedure1<? super Button>)((Procedures.Procedure1)button -> {
                button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                button.setText("4");
                button.setSelection(false);
            }));
            this.junitVersion5 = this.Radio(childComposite, (Procedures.Procedure1<? super Button>)((Procedures.Procedure1)button -> {
                button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                button.setText("5");
                button.setSelection(true);
            }));
        }));
        this.Group(control, (Procedures.Procedure1<? super Group>)((Procedures.Procedure1)group -> {
            group.setText(Messages.AdvancedNewProjectPage_prefBuildSys);
            this.preferredBuildSystem = this.DropDown((Composite)group, (Procedures.Procedure1<? super Combo>)((Procedures.Procedure1)combo -> {
                combo.setEnabled(true);
                combo.setItems((String[])Arrays.stream(BuildSystem.values()).map(sl -> sl.toString()).toArray(String[]::new));
            }));
        }));
        this.Group(control, (Procedures.Procedure1<? super Group>)((Procedures.Procedure1)group -> {
            group.setText(Messages.AdvancedNewProjectPage_languageServer);
            this.createLanguageServer = this.DropDown((Composite)group, (Procedures.Procedure1<? super Combo>)((Procedures.Procedure1)combo -> {
                combo.setEnabled(false);
                combo.setItems((String[])Arrays.stream(LanguageServer.values()).map(sl -> sl.toString()).toArray(String[]::new));
                this.InfoDecoration((Control)combo, Messages.AdvancedNewProjectPage_languageServer_description);
            }));
        }));
        this.Group(control, (Procedures.Procedure1<? super Group>)((Procedures.Procedure1)group -> {
            group.setText(Messages.AdvancedNewProjectPage_srcLayout);
            this.sourceLayout = this.DropDown((Composite)group, (Procedures.Procedure1<? super Combo>)((Procedures.Procedure1)combo -> {
                combo.setEnabled(true);
                combo.setItems((String[])Arrays.stream(SourceLayout.values()).map(sl -> sl.toString()).toArray(String[]::new));
            }));
        }));
        this.statusWidget = new StatusWidget(control, 0);
        this.statusWidget.setLayoutData(new GridData(4, 128, true, false));
        final List<Button> uiButtons = Arrays.asList(this.createUiProject, this.createWebProject);
        SelectionAdapter selectionControlUi = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    if (!AdvancedNewProjectPage.this.createIdeProject.getSelection()) {
                        AdvancedNewProjectPage.this.autoSelectIdeProject = true;
                    }
                    AdvancedNewProjectPage.this.createIdeProject.setSelection(true);
                    AdvancedNewProjectPage.this.createIdeProject.setEnabled(false);
                } else {
                    if (Iterables.all((Iterable)uiButtons, uiButton -> !uiButton.getSelection())) {
                        AdvancedNewProjectPage.this.createIdeProject.setEnabled(true);
                    }
                    if (e.getSource() == AdvancedNewProjectPage.this.createUiProject) {
                        AdvancedNewProjectPage.this.createSDKProject.setSelection(false);
                        AdvancedNewProjectPage.this.createP2Project.setSelection(false);
                    }
                }
                AdvancedNewProjectPage.this.validate(e);
            }
        };
        SelectionAdapter selectionControlUpdateSite = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    if (!AdvancedNewProjectPage.this.createSDKProject.getSelection()) {
                        AdvancedNewProjectPage.this.autoSelectSDKProject = true;
                    }
                    AdvancedNewProjectPage.this.createSDKProject.setSelection(true);
                    AdvancedNewProjectPage.this.createSDKProject.setEnabled(false);
                } else {
                    AdvancedNewProjectPage.this.createSDKProject.setEnabled(true);
                }
                AdvancedNewProjectPage.this.validate(e);
            }
        };
        this.createUiProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean uiProjectSelected = AdvancedNewProjectPage.this.createUiProject.getSelection();
                AdvancedNewProjectPage.this.createUiProjectSubGroup.setEnabled(uiProjectSelected);
                AdvancedNewProjectPage.this.createSDKProject.setEnabled(uiProjectSelected);
                AdvancedNewProjectPage.this.createP2Project.setEnabled(uiProjectSelected);
                AdvancedNewProjectPage.this.validate(e);
            }
        });
        this.preferredBuildSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedNewProjectPage.this.createLanguageServer.setEnabled(AdvancedNewProjectPage.this.getPreferredBuildSystem() != BuildSystem.NONE);
                AdvancedNewProjectPage.this.validate(e);
            }
        });
        this.createLanguageServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AdvancedNewProjectPage.this.isSelected(AdvancedNewProjectPage.this.createLanguageServer, (Enum<?>)LanguageServer.NONE)) {
                    if (Iterables.all((Iterable)uiButtons, uiButton -> !uiButton.getSelection())) {
                        AdvancedNewProjectPage.this.createIdeProject.setEnabled(true);
                    }
                } else if (!AdvancedNewProjectPage.this.createIdeProject.getSelection()) {
                    AdvancedNewProjectPage.this.createIdeProject.setSelection(true);
                    AdvancedNewProjectPage.this.autoSelectIdeProject = true;
                }
                AdvancedNewProjectPage.this.validate(e);
            }
        });
        this.createTestProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = AdvancedNewProjectPage.this.createTestProject.getSelection();
                AdvancedNewProjectPage.this.junitVersion4.setEnabled(enabled);
                AdvancedNewProjectPage.this.junitVersion5.setEnabled(enabled);
                AdvancedNewProjectPage.this.validate(e);
            }
        });
        SelectionAdapter selectionControl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedNewProjectPage.this.validate(e);
            }
        };
        this.sourceLayout.addSelectionListener((SelectionListener)selectionControl);
        this.createUiProject.addSelectionListener((SelectionListener)selectionControlUi);
        this.createWebProject.addSelectionListener((SelectionListener)selectionControlUi);
        this.createIdeProject.addSelectionListener((SelectionListener)selectionControl);
        this.createSDKProject.addSelectionListener((SelectionListener)selectionControl);
        this.createP2Project.addSelectionListener((SelectionListener)selectionControlUpdateSite);
        this.createLanguageServer.addSelectionListener((SelectionListener)selectionControl);
        this.setDefaults();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.xtext.xtext.ui.newProject_Advanced");
        this.setControl((Control)control);
    }

    public void validate(SelectionEvent e) {
        this.statusWidget.clearStatus();
        this.checkWidgets(e);
        this.setPageComplete(this.statusWidget.getSevertity() != 3);
    }

    public void checkWidgets(SelectionEvent e) {
        String message;
        boolean isSelected;
        String message2;
        List<Button> uiButtons = Arrays.asList(this.createUiProject, this.createWebProject);
        if (this.isSelected(this.preferredBuildSystem, (Enum<?>)BuildSystem.MAVEN) && !this.isBundleResolved("org.eclipse.m2e.maven.runtime")) {
            this.reportIssue(2, Messages.AdvancedNewProjectPage_noM2e);
        }
        if (this.isSelected(this.preferredBuildSystem, (Enum<?>)BuildSystem.GRADLE) && !this.isBundleResolved("org.eclipse.buildship.core")) {
            this.reportIssue(2, Messages.AdvancedNewProjectPage_noBuildship);
        }
        if (this.isSelected(this.preferredBuildSystem, (Enum<?>)BuildSystem.GRADLE) && this.createUiProject.getSelection()) {
            this.reportIssue(2, Messages.AdvancedNewProjectPage_eclipseAndGradleWarn);
        }
        if (this.createUiProject.getSelection() && this.createP2Project.getSelection() && !this.createSDKProject.getSelection()) {
            this.addIssue(1, Messages.AdvancedNewProjectPage_p2AndSdkInfo);
        }
        if (e == null) {
            return;
        }
        Object source = e.getSource();
        if (this.createUiProject.getSelection() && !this.isSelected(this.sourceLayout, (Enum<?>)SourceLayout.PLAIN)) {
            if (this.createUiProject == source) {
                message2 = "'" + this.createUiProject.getText() + "' requires " + SourceLayout.PLAIN + " source layout. " + "Please <a>select '" + SourceLayout.PLAIN + "'</a> source layout.";
                this.reportIssue(3, message2, () -> this.select(this.sourceLayout, (Enum<?>)SourceLayout.PLAIN));
            } else {
                message2 = SourceLayout.MAVEN + " source layout is not supported by the '" + this.createUiProject.getText() + "' project. " + "Please <a>deselect '" + this.createUiProject.getText() + "'</a>.";
                this.reportIssue(3, message2, () -> this.createUiProject.setSelection(false));
            }
        }
        if (this.isSelected(this.preferredBuildSystem, (Enum<?>)BuildSystem.NONE) && this.isSelected(this.sourceLayout, (Enum<?>)SourceLayout.MAVEN)) {
            if (this.preferredBuildSystem == source) {
                message2 = "Maven/Gradle source layout is not supported without a build system. Please <a>select '" + SourceLayout.PLAIN + "'</a> source layout.";
                this.reportIssue(3, message2, () -> this.select(this.sourceLayout, (Enum<?>)SourceLayout.PLAIN));
            } else {
                message2 = "Maven/Gradle source layout is only supported when using Maven or Gradle build system. You need to choose Maven or Gradle as build system. Select <a>Gradle</a> build.";
                this.reportIssue(3, message2, () -> this.select(this.preferredBuildSystem, (Enum<?>)BuildSystem.GRADLE));
            }
        }
        if (this.createWebProject.getSelection() && this.isSelected(this.preferredBuildSystem, (Enum<?>)BuildSystem.NONE)) {
            if (this.preferredBuildSystem == source) {
                message2 = "The '" + this.createWebProject.getText() + "' project can not be build without a build system. " + "Please <a>deselect '" + this.createWebProject.getText() + "'</a>.";
                this.reportIssue(3, message2, () -> this.createWebProject.setSelection(false));
            } else {
                message2 = "To build the '" + this.createWebProject.getText() + "' " + "project, you need to choose Maven or Gradle as build system." + "Select <a>Gradle</a> build.";
                this.reportIssue(3, message2, () -> this.select(this.preferredBuildSystem, (Enum<?>)BuildSystem.GRADLE));
            }
        }
        if (isSelected = Iterables.any(uiButtons, uiButton -> uiButton.getSelection())) {
            this.createIdeProject.setEnabled(false);
        }
        if (this.autoSelectIdeProject) {
            this.autoSelectIdeProject = false;
            message = "'" + this.createIdeProject.getText() + "' project was automatically selected as option '" + ((Button)source).getText() + "' requires it.";
            this.reportIssue(1, message);
        }
        if (this.autoSelectSDKProject) {
            this.autoSelectSDKProject = false;
            message = "'" + this.createSDKProject.getText() + "' was automatically selected as option '" + ((Button)source).getText() + "' requires it.";
            this.reportIssue(1, message);
        }
    }

    protected void select(Combo combo, Enum<?> enu) {
        String[] items = combo.getItems();
        int i = 0;
        while (i < items.length) {
            if (enu.toString().equals(items[i])) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    protected boolean isSelected(Combo combo, Enum<?> enu) {
        return enu.toString().equals(combo.getText());
    }

    protected <T extends Control> void reportIssue(int severity, String text) {
        this.reportIssue(severity, text, () -> {});
    }

    protected <T extends Control> void reportIssue(int severity, String text, Procedures.Procedure0 fix) {
        this.statusWidget.setStatus(severity, text, fix, () -> this.validate(null));
        ((Composite)this.getControl()).layout();
    }

    protected <T extends Control> void addIssue(int severity, String text) {
        this.statusWidget.addStatus(severity, text);
        ((Composite)this.getControl()).layout();
    }

    protected boolean isBundleResolved(String bundleId) {
        Bundle[] bundles = Activator.getInstance().getBundle().getBundleContext().getBundles();
        Optional<Bundle> bundle = Arrays.stream(bundles).filter(b -> bundleId.equals(b.getSymbolicName())).findFirst();
        return bundle.isPresent() && (bundle.get().getState() & 0xC | 0x20) != 0;
    }

    protected Group Group(Composite parent, Procedures.Procedure1<? super Group> config) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        config.apply((Object)group);
        return group;
    }

    protected Button CheckBox(Composite composite, Procedures.Procedure1<? super Button> config) {
        Button button = new Button(composite, 32);
        button.setFont(button.getParent().getFont());
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        config.apply((Object)button);
        return button;
    }

    protected Button Radio(Composite composite, Procedures.Procedure1<? super Button> config) {
        Button button = new Button(composite, 16);
        button.setFont(button.getParent().getFont());
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        config.apply((Object)button);
        return button;
    }

    protected Combo DropDown(Composite parent, Procedures.Procedure1<? super Combo> config) {
        Combo combo = new Combo(parent, 8);
        combo.setFont(parent.getFont());
        combo.setLayoutData((Object)new GridData(768));
        config.apply((Object)combo);
        return combo;
    }

    protected ControlDecoration InfoDecoration(Control control, String text) {
        FieldDecoration infoField = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        ControlDecoration controlDecoration = new ControlDecoration(control, 131200);
        controlDecoration.setImage(infoField.getImage());
        controlDecoration.setDescriptionText(text);
        controlDecoration.setShowHover(true);
        return controlDecoration;
    }

    protected void setDefaults() {
        this.createUiProject.setSelection(true);
        this.createIdeProject.setSelection(true);
        this.createTestProject.setSelection(true);
        this.createWebProject.setSelection(false);
        this.createSDKProject.setSelection(false);
        this.createP2Project.setSelection(false);
        this.select(this.preferredBuildSystem, (Enum<?>)BuildSystem.NONE);
        this.select(this.createLanguageServer, (Enum<?>)LanguageServer.NONE);
        this.select(this.sourceLayout, (Enum<?>)SourceLayout.PLAIN);
    }

    public boolean isCreateUiProject() {
        return this.createUiProject.getSelection();
    }

    public boolean isCreateTestProject() {
        return this.createTestProject.getSelection();
    }

    public boolean isCreateIdeProject() {
        return this.createIdeProject.getSelection();
    }

    public boolean isCreateWebProject() {
        return this.createWebProject.getSelection();
    }

    public boolean isCreateSdkProject() {
        return this.createUiProject.getSelection() && this.createSDKProject.getSelection();
    }

    public boolean isCreateP2Project() {
        return this.createUiProject.getSelection() && this.createP2Project.getSelection();
    }

    public BuildSystem getPreferredBuildSystem() {
        return BuildSystem.values()[this.preferredBuildSystem.getSelectionIndex()];
    }

    public SourceLayout getSourceLayout() {
        return SourceLayout.values()[this.sourceLayout.getSelectionIndex()];
    }

    public LanguageServer getLanguageServer() {
        if (this.getPreferredBuildSystem() == BuildSystem.NONE) {
            return LanguageServer.NONE;
        }
        return LanguageServer.values()[this.createLanguageServer.getSelectionIndex()];
    }

    public JUnitVersion getSelectedJUnitVersion() {
        if (this.junitVersion4.getSelection()) {
            return JUnitVersion.JUNIT_4;
        }
        if (this.junitVersion5.getSelection()) {
            return JUnitVersion.JUNIT_5;
        }
        throw new IllegalStateException("JUnit version could not be determined");
    }
}

