/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.wizards.palette;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.internal.core.UiMessages;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.utils.dialogfields.ComboDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogFieldUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.ui.ProjectSelectionDialogField;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public final class NewProjectPalettePage
extends WizardPage {
    private IJavaProject m_initialProject;
    private ProjectSelectionDialogField m_projectField;
    private ComboDialogField m_toolkitField;
    private final List<ToolkitDescription> m_toolkits = Lists.newArrayList();
    private boolean m_validationEnabled;
    protected final IDialogFieldListener m_validateListener = new IDialogFieldListener(){

        public void dialogFieldChanged(DialogField field) {
            NewProjectPalettePage.this.validateAll();
        }
    };

    public NewProjectPalettePage() {
        super("main");
        this.setTitle(UiMessages.NewProjectPalettePage_title);
        this.setDescription(UiMessages.NewProjectPalettePage_description);
    }

    public void init(IStructuredSelection selection) {
        IResource resource;
        IAdaptable adaptable;
        IJavaElement javaElement = null;
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof IAdaptable && (javaElement = (IJavaElement)(adaptable = (IAdaptable)selectedElement).getAdapter(IJavaElement.class)) == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null && resource.getType() != 8) {
            while (javaElement == null && resource.getType() != 4) {
                resource = resource.getParent();
                javaElement = (IJavaElement)resource.getAdapter(IJavaElement.class);
            }
            if (javaElement == null) {
                javaElement = JavaCore.create((IResource)resource);
            }
        }
        if (javaElement != null) {
            this.m_initialProject = (IJavaProject)javaElement.getAncestor(2);
        }
    }

    IJavaProject getJavaProject() {
        return this.m_projectField.getProject();
    }

    ToolkitDescription getToolkit() {
        return this.m_toolkits.get(this.m_toolkitField.getSelectionIndex());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayoutFactory.create((Composite)container).columns(3);
        this.m_projectField = ProjectSelectionDialogField.create();
        this.m_projectField.setButtonLabel(UiMessages.NewProjectPalettePage_projectBrowse);
        this.m_projectField.setProject(this.m_initialProject);
        this.doCreateField((DialogField)this.m_projectField, UiMessages.NewProjectPalettePage_projectLabel);
        this.m_projectField.setUpdateListener(this.m_validateListener);
        this.m_toolkitField = new ComboDialogField(8);
        this.m_toolkitField.setVisibleItemCount(10);
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                Collections.addAll(NewProjectPalettePage.this.m_toolkits, DescriptionHelper.getToolkits());
                Collections.sort(NewProjectPalettePage.this.m_toolkits, new Comparator<ToolkitDescription>(){

                    @Override
                    public int compare(ToolkitDescription o1, ToolkitDescription o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (ToolkitDescription toolkit : NewProjectPalettePage.this.m_toolkits) {
                    NewProjectPalettePage.this.m_toolkitField.addItem(toolkit.getName());
                }
            }
        });
        this.m_toolkitField.selectItem(1);
        this.doCreateField((DialogField)this.m_toolkitField, UiMessages.NewProjectPalettePage_toolkitLabel);
        this.m_projectField.setFocus();
        this.m_validationEnabled = true;
        this.validateAll();
    }

    private void validateAll() {
        if (this.m_validationEnabled) {
            String errorMessage = this.validate();
            this.setErrorMessage(errorMessage);
            this.setPageComplete(errorMessage == null);
        }
    }

    private String validate() {
        IJavaProject javaProject = this.m_projectField.getProject();
        if (javaProject == null) {
            return UiMessages.NewProjectPalettePage_validateNoProject;
        }
        int toolkitIndex = this.m_toolkitField.getSelectionIndex();
        ToolkitDescription toolkit = this.m_toolkits.get(toolkitIndex);
        IFile paletteFile = javaProject.getProject().getFile((IPath)new Path("wbp-meta/" + toolkit.getId() + ".wbp-palette.xml"));
        if (paletteFile.exists()) {
            return MessageFormat.format(UiMessages.NewProjectPalettePage_validateHasToolkit, toolkit.getName(), paletteFile.getFullPath());
        }
        return null;
    }

    private void doCreateField(DialogField dialogField, String labelText) {
        dialogField.setLabelText(labelText);
        dialogField.setDialogFieldListener(this.m_validateListener);
        Composite parent = (Composite)this.getControl();
        DialogFieldUtils.fillControls((Composite)parent, (DialogField)dialogField, (int)3, (int)40);
    }
}

