/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.condition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.swt.api.Table;
import org.eclipse.reddeer.swt.api.TableItem;
import org.hamcrest.Matcher;

public class TableHasRows
extends AbstractWaitCondition {
    private final Table table;
    private final Matcher<?> matcher;
    private List<TableItem> resultRows;

    public TableHasRows(Table table) {
        this(table, null);
    }

    public TableHasRows(Table table, Matcher<?> matcher) {
        this.table = table;
        this.matcher = matcher != null ? matcher : null;
        this.resultRows = new ArrayList<TableItem>();
    }

    private List<TableItem> search() {
        ArrayList<TableItem> matchedItems = new ArrayList<TableItem>();
        for (TableItem item : this.table.getItems()) {
            if (!this.matcher.matches((Object)item)) continue;
            matchedItems.add(item);
        }
        return matchedItems;
    }

    public boolean test() {
        if (this.table != null && this.matcher == null) {
            return this.table.rowCount() > 0;
        }
        this.resultRows = this.search();
        return !this.resultRows.isEmpty();
    }

    public String description() {
        return "table contains TableItems";
    }

    public List<TableItem> getResult() {
        return this.resultRows.isEmpty() ? null : this.resultRows;
    }
}

