/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.presentation.actions;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.presentation.PreferencesEditorPlugin;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class ShowInExplorerAction
extends ActionDelegate {
    private static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();
    protected ISelection targetSelection;

    public void run(IAction action) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            IViewPart packageExplorerView = page.showView("org.eclipse.jdt.ui.PackageExplorer");
            IShowInTarget showInTarget = (IShowInTarget)ObjectUtil.adapt((Object)packageExplorerView, IShowInTarget.class);
            showInTarget.show(new ShowInContext(null, this.targetSelection));
        }
        catch (PartInitException ex) {
            PreferencesEditorPlugin.INSTANCE.log(ex);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ArrayList<Object> resources = new ArrayList<Object>();
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof PreferenceNode) {
                    PreferenceNode preferenceNode = (PreferenceNode)object;
                    String path = preferenceNode.getLocation();
                    if (path != null) {
                        File file = new File(path);
                        URI uri = file.toURI();
                        IFile[] files = WORKSPACE_ROOT.findFilesForLocationURI(uri);
                        if (files.length > 0) {
                            resources.addAll(Arrays.asList(files));
                        }
                    } else {
                        IProject project;
                        PreferenceNode grandParent;
                        PreferenceNode parent = preferenceNode.getParent();
                        if (parent != null && "project".equals(parent.getName()) && (grandParent = parent.getParent()) != null && "".equals(grandParent.getName()) && (project = WORKSPACE_ROOT.getProject(preferenceNode.getName())).isAccessible()) {
                            resources.add(project);
                        }
                    }
                }
                ++n2;
            }
            if (!resources.isEmpty()) {
                this.targetSelection = new StructuredSelection(resources);
                action.setEnabled(true);
                return;
            }
        }
        this.targetSelection = null;
        action.setEnabled(false);
    }
}

