/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class InterestUpdateDeltaListener
implements IElementChangedListener {
    private static boolean asyncExecMode = true;

    public void elementChanged(ElementChangedEvent event) {
        IModelElementDelta delta = event.getDelta();
        this.handleDelta(delta.getAffectedChildren());
    }

    private void handleDelta(IModelElementDelta[] delta) {
        try {
            IInteractionElement element;
            IModelElement added = null;
            IModelElement removed = null;
            IModelElementDelta[] iModelElementDeltaArray = delta;
            int n = delta.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElementDelta child = iModelElementDeltaArray[n2];
                if (child.getElement() instanceof ISourceModule && ((ISourceModule)child.getElement()).getOwner() != null) {
                    return;
                }
                if (child.getKind() == 1) {
                    if (added == null) {
                        added = child.getElement();
                    }
                } else if (child.getKind() == 2 && removed == null) {
                    removed = child.getElement();
                }
                this.handleDelta(child.getAffectedChildren());
                ++n2;
            }
            if (added != null && removed != null) {
                element = ContextCore.getContextManager().getElement(removed.getHandleIdentifier());
                if (element != null) {
                    this.resetHandle(element, added.getHandleIdentifier());
                }
            } else if (removed != null && (element = ContextCore.getContextManager().getElement(removed.getHandleIdentifier())) != null) {
                this.delete(element);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Delta update failed", t));
        }
    }

    private void resetHandle(IInteractionElement element, String newHandle) {
        if (!asyncExecMode) {
            ContextCore.getContextManager().updateHandle(element, newHandle);
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                workbench.getDisplay().asyncExec(() -> ContextCore.getContextManager().updateHandle(element, newHandle));
            }
        }
    }

    private void delete(IInteractionElement element) {
        ArrayList<IInteractionElement> elements = new ArrayList<IInteractionElement>();
        elements.add(element);
        if (!asyncExecMode) {
            ContextCore.getContextManager().deleteElements(elements);
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                workbench.getDisplay().asyncExec(() -> ContextCore.getContextManager().deleteElements((Collection)elements));
            }
        }
    }

    public static void setAsyncExecMode(boolean asyncExecMode) {
        InterestUpdateDeltaListener.asyncExecMode = asyncExecMode;
    }
}

