/*
 * Copyright (c) 2018 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.map.primitive;

import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.map.primitive.MutableIntDoubleMap;
import org.eclipse.collections.api.map.primitive.IntDoubleMap;

/**
 * A factory which creates instances of type {@link MutableIntDoubleMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableIntDoubleMapFactory
{
    MutableIntDoubleMap empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableIntDoubleMap of();

    /**
     * Same as {@link #empty()}.
     */
    MutableIntDoubleMap with();

    /**
     * Same as {@link #empty()}. but takes in an initial capacity
     */
    MutableIntDoubleMap ofInitialCapacity(int capacity);

    /**
     * Same as {@link #empty()}. but takes in an initial capacity
     */
    MutableIntDoubleMap withInitialCapacity(int capacity);

    /**
     * Same as {@link #withAll(IntDoubleMap)}.
     */
    MutableIntDoubleMap ofAll(IntDoubleMap map);

    MutableIntDoubleMap withAll(IntDoubleMap map);

    /**
     * Creates an {@code MutableIntDoubleMap} from an {@code Iterable<T>} by applying {@code keyFunction} and {@code valueFunction}.
     *
     * @since 10.0
     */
    <T> MutableIntDoubleMap from(Iterable<T> iterable, IntFunction<? super T> keyFunction, DoubleFunction<? super T> valueFunction);
}
