/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.pro.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class QtProjectVariable {
    private static final Pattern REGEX = Pattern.compile("(?m)^\\h*((?:[_a-zA-Z][_a-zA-Z0-9]*\\.)*[_a-zA-Z][_a-zA-Z0-9]*)\\h*(=|\\+=|-=|\\*=)\\h*([^#\\v]*?)\\h*((?:(\\\\)\\h*)?(#[^\\v]*)?$)");
    private static final Pattern LINE_ESCAPE_REGEX = Pattern.compile("(?m)^(\\h*)([^#\\v]*?)\\h*((?:(\\\\)\\h*)?(#[^\\v]*)?$)");
    private static final int GROUP_VAR_NAME = 1;
    private static final int GROUP_VAR_ASSIGNMENT = 2;
    private static final int GROUP_VAR_CONTENTS = 3;
    private static final int GROUP_VAR_TERMINATOR = 4;
    private static final int GROUP_VAR_LINE_ESCAPE = 5;
    private static final int GROUP_VAR_COMMENT = 6;
    private static final int GROUP_LINE_INDENT = 1;
    private static final int GROUP_LINE_CONTENTS = 2;
    private static final int GROUP_LINE_TERMINATOR = 3;
    private static final int GROUP_LINE_LINE_ESCAPE = 4;
    private static final int GROUP_LINE_COMMENT = 5;
    private final int startOffset;
    private final int endOffset;
    private final String text;
    private final List<MatchResult> matchResults;

    public static QtProjectVariable findNextVariable(Scanner scanner) {
        ArrayList<MatchResult> matchResults = new ArrayList<MatchResult>();
        String match = scanner.findWithinHorizon(REGEX, 0);
        if (match == null) {
            return null;
        }
        MatchResult matchResult = scanner.match();
        matchResults.add(matchResult);
        if (matchResult.group(4).startsWith("\\")) {
            while ((match = scanner.findWithinHorizon(LINE_ESCAPE_REGEX, 0)) != null) {
                matchResult = scanner.match();
                matchResults.add(matchResult);
                if (matchResult.group(3).startsWith("\\")) continue;
            }
        }
        return new QtProjectVariable(matchResults);
    }

    private QtProjectVariable(List<MatchResult> matches) {
        this.startOffset = matches.get(0).start();
        this.endOffset = matches.get(matches.size() - 1).end();
        this.matchResults = matches;
        StringBuilder sb = new StringBuilder();
        for (MatchResult m : matches) {
            sb.append(m.group());
        }
        this.text = sb.toString();
    }

    public int getOffset() {
        return this.startOffset;
    }

    public int getLength() {
        return this.endOffset - this.startOffset;
    }

    public String getName() {
        return this.matchResults.get(0).group(1);
    }

    public String getAssignmentOperator() {
        return this.matchResults.get(0).group(2);
    }

    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.matchResults.get(0).group(3));
        int i = 1;
        while (i < this.matchResults.size()) {
            values.add(this.matchResults.get(i).group(2));
            ++i;
        }
        return values;
    }

    public String getIndentString(int line) {
        MatchResult match = this.matchResults.get(line);
        if (line == 0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < match.start(3) - match.start()) {
                sb.append(' ');
                ++i;
            }
            return sb.toString();
        }
        return match.group(1);
    }

    public int getValueOffsetForLine(int line) {
        if (line == 0) {
            return this.matchResults.get(line).start(3);
        }
        return this.matchResults.get(line).start(2);
    }

    public String getValueForLine(int line) {
        if (line == 0) {
            return this.matchResults.get(line).group(3);
        }
        return this.matchResults.get(line).group(2);
    }

    public int getLineEscapeReplacementOffset(int line) {
        if (line == 0) {
            return this.matchResults.get(line).end(3);
        }
        return this.matchResults.get(line).end(2);
    }

    public String getLineEscapeReplacementString(int line) {
        int commentOffset = -1;
        int contentsOffset = -1;
        if (line == 0) {
            commentOffset = this.matchResults.get(line).start(6);
            contentsOffset = this.matchResults.get(line).end(3);
        } else {
            commentOffset = this.matchResults.get(line).start(5);
            contentsOffset = this.matchResults.get(line).end(2);
        }
        if (commentOffset > 0 && commentOffset - contentsOffset == 0) {
            return " \\ ";
        }
        return " \\";
    }

    public int getLineEscapeOffset(int line) {
        if (line == 0) {
            return this.matchResults.get(line).end(3);
        }
        return this.matchResults.get(line).end(2);
    }

    public int getLineEscapeEnd(int line) {
        int end = -1;
        end = line == 0 ? this.matchResults.get(line).end(5) : this.matchResults.get(line).end(4);
        if (end > 0) {
            return end;
        }
        if (line == 0) {
            return this.matchResults.get(line).end(4);
        }
        return this.matchResults.get(line).end(3);
    }

    public int getEndOffset() {
        return this.matchResults.get(this.matchResults.size() - 1).end();
    }

    public String getText() {
        return this.text;
    }

    public int getNumberOfLines() {
        return this.matchResults.size();
    }

    public String getLine(int line) {
        return this.matchResults.get(line).group();
    }

    public int getLineOffset(int line) {
        return this.matchResults.get(line).start();
    }

    public int getValueIndex(String value) {
        return this.getValueIndex(value, false);
    }

    public int getValueIndex(String value, boolean ignoreCase) {
        int line = 0;
        for (String val : this.getValues()) {
            if (ignoreCase ? val.equalsIgnoreCase(value) : val.equals(value)) {
                return line;
            }
            ++line;
        }
        return -1;
    }

    public int getLineEnd(int line) {
        return this.matchResults.get(line).end();
    }
}

