/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.Arrays;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Validate;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.AddVariableToValidateCommand;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.RemoveValidateVariableCommand;
import org.eclipse.bpel.ui.details.providers.AbstractContentProvider;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.dialogs.VariableSelectorDialog;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ValidateVariablesSection
extends BPELPropertySection {
    protected Button fAddButton;
    protected Button fRemoveButton;
    List fVariableList;
    ListViewer fVariablesViewer;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                if (n.getFeature() == BPELPackage.eINSTANCE.getValidate_Variables()) {
                    ValidateVariablesSection.this.updateVariableWidgets(null);
                    ValidateVariablesSection.this.refreshAdapters();
                }
            }
        }, new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                if (n.getNotifier() instanceof Variable) {
                    ValidateVariablesSection.this.updateVariableWidgets((Variable)n.getNotifier());
                    ValidateVariablesSection.this.refreshAdapters();
                }
            }
        }};
    }

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        Validate validate = (Validate)this.getModel();
        EList variables = validate.getVariables();
        if (variables != null) {
            for (Variable var : variables) {
                this.fAdapters[1].addToObject((Notifier)var);
            }
        }
    }

    protected void createVariablesWidgets(final Composite composite) {
        this.fAddButton = this.fWidgetFactory.createButton(composite, Messages.ValidateDetails_1, 8);
        this.fRemoveButton = this.fWidgetFactory.createButton(composite, Messages.ValidateDetails_2, 8);
        Label validateVariablesLabel = this.fWidgetFactory.createLabel(composite, Messages.ValidateDetails_3);
        this.fVariableList = this.fWidgetFactory.createList(composite, 68098);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.top = new FlatFormAttachment(0, 4);
        validateVariablesLabel.setLayoutData((Object)data);
        data = new FlatFormData();
        data.width = BPELUtil.calculateButtonWidth((Widget)this.fAddButton, 60);
        data.right = new FlatFormAttachment((Control)this.fRemoveButton, -5);
        data.top = new FlatFormAttachment(0, 4);
        this.fAddButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.width = BPELUtil.calculateButtonWidth((Widget)this.fRemoveButton, 60);
        data.right = new FlatFormAttachment(100, -10);
        data.top = new FlatFormAttachment(0, 4);
        this.fRemoveButton.setLayoutData((Object)data);
        this.fRemoveButton.setEnabled(false);
        this.fAddButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = composite.getShell();
                Object model = ValidateVariablesSection.this.getInput();
                VariableSelectorDialog dialog = new VariableSelectorDialog(shell, (EObject)model, ModelHelper.getVariableType(model, 0)){

                    protected void computeResult() {
                        Object[] results = this.getSelectedElements();
                        this.setResult(Arrays.asList(results));
                    }
                };
                dialog.setMultipleSelection(true);
                dialog.setTitle(Messages.ValidateDetails_4);
                if (dialog.open() == 0) {
                    CompoundCommand ccmd = new CompoundCommand();
                    Variable variable = null;
                    Object[] objectArray = dialog.getResult();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object next = objectArray[n2];
                        variable = (Variable)next;
                        ccmd.add((Command)new AddVariableToValidateCommand((EObject)ValidateVariablesSection.this.getInput(), variable));
                        ++n2;
                    }
                    ValidateVariablesSection.this.runCommand((Command)ccmd);
                    ValidateVariablesSection.this.fVariablesViewer.setSelection((ISelection)new StructuredSelection((Object)variable), true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Listener removeListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 2 && e.character != '\u007f') {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)ValidateVariablesSection.this.fVariablesViewer.getSelection();
                int selectionIndex = ValidateVariablesSection.this.fVariableList.getSelectionIndex();
                CompoundCommand ccmd = new CompoundCommand();
                Object[] objectArray = sel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object next = objectArray[n2];
                    Variable var = (Variable)next;
                    ccmd.add((Command)new RemoveValidateVariableCommand((EObject)ValidateVariablesSection.this.getInput(), var));
                    ++n2;
                }
                ValidateVariablesSection.this.runCommand((Command)ccmd);
                int items = ValidateVariablesSection.this.fVariableList.getItemCount();
                if (items > 0) {
                    selectionIndex = selectionIndex < items ? selectionIndex : 0;
                    ValidateVariablesSection.this.fVariableList.setSelection(selectionIndex);
                } else {
                    ValidateVariablesSection.this.fVariablesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        };
        this.fVariableList.addListener(2, removeListener);
        this.fRemoveButton.addListener(13, removeListener);
        this.fRemoveButton.addListener(14, removeListener);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment(100, -10);
        data.top = new FlatFormAttachment((Control)this.fAddButton, 4);
        data.bottom = new FlatFormAttachment(100, -4);
        this.fVariableList.setLayoutData((Object)data);
        this.fVariablesViewer = new ListViewer(this.fVariableList);
        this.fVariablesViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
        this.fVariablesViewer.setContentProvider((IContentProvider)new AbstractContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                try {
                    Validate input = (Validate)inputElement;
                    EList l = input.getVariables();
                    return l == null ? EMPTY_ARRAY : l.toArray();
                }
                catch (Throwable throwable) {
                    return EMPTY_ARRAY;
                }
            }
        });
        this.fVariablesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ValidateVariablesSection.this.fRemoveButton.setEnabled(!ValidateVariablesSection.this.fVariablesViewer.getSelection().isEmpty());
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.bpel.ui.property_validate");
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        this.createVariablesWidgets(composite);
    }

    protected void updateVariableWidgets(Variable var) {
        Object input = this.getInput();
        if (input == null) {
            throw new IllegalStateException();
        }
        this.fVariablesViewer.setInput(input);
        if (var != null) {
            this.fVariablesViewer.refresh((Object)var, true);
        } else {
            this.fVariablesViewer.refresh();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateVariableWidgets(null);
    }

    @Override
    public Object getUserContext() {
        return ((StructuredSelection)this.fVariablesViewer.getSelection()).getFirstElement();
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.fVariableList.setFocus();
        if (userContext != null) {
            this.fVariablesViewer.setSelection((ISelection)new StructuredSelection(userContext), true);
        } else {
            this.fVariablesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        this.saveUserContextToInput();
        super.basicSetInput(newInput);
        this.restoreUserContextFromInput();
    }
}

