/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.layouts.AlignedFlowLayout;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.GraphicalBPELRootEditPart;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.InsertInContainerCommand;
import org.eclipse.bpel.ui.commands.ReorderInContainerCommand;
import org.eclipse.bpel.ui.commands.SetNameAndDirectEditCommand;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.CollapsableEditPart;
import org.eclipse.bpel.ui.editparts.CompositeActivityEditPart;
import org.eclipse.bpel.ui.editparts.ElseIfEditPart;
import org.eclipse.bpel.ui.editparts.IfEditPart;
import org.eclipse.bpel.ui.editparts.InvokeEditPart;
import org.eclipse.bpel.ui.editparts.ProcessEditPart;
import org.eclipse.bpel.ui.editparts.ScopeEditPart;
import org.eclipse.bpel.ui.editparts.StartNodeEditPart;
import org.eclipse.bpel.ui.util.ImplicitLinkHandlerConnectionRouter;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.swt.graphics.Color;

public class BPELOrderedLayoutEditPolicy
extends FlowLayoutEditPolicy {
    protected ArrayList<PolylineConnection> polyLineConnectionList = new ArrayList();
    protected Color arrowColor = BPELUIPlugin.INSTANCE.getColorRegistry().get("implicitLink");

    protected Command createAddCommand(EditPart child, EditPart before) {
        return new InsertInContainerCommand((EObject)this.getHost().getModel(), (EObject)child.getModel(), before == null ? null : (EObject)before.getModel());
    }

    protected Command createMoveChildCommand(EditPart child, EditPart before) {
        return new ReorderInContainerCommand((EObject)this.getHost().getModel(), (EObject)child.getModel(), before == null ? null : (EObject)before.getModel());
    }

    protected Command getCreateCommand(CreateRequest request) {
        CompoundCommand command = null;
        try {
            EditPart before = this.getInsertionReference((Request)request);
            EObject parent = (EObject)this.getHost().getModel();
            EObject child = (EObject)request.getNewObject();
            EObject beforeObject = (EObject)(before != null ? before.getModel() : null);
            command = new CompoundCommand();
            command.add((Command)new InsertInContainerCommand(parent, child, beforeObject));
            command.add((Command)new SetNameAndDirectEditCommand(child, this.getHost().getViewer()));
        }
        catch (Exception exception) {}
        return command;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected EditPart getInsertionReference(Request request) {
        if (request instanceof DropRequest) {
            Point pt = ((DropRequest)request).getLocation();
            if (pt == null) {
                return null;
            }
            return super.getInsertionReference(request);
        }
        return null;
    }

    public void refreshConnections() {
        this.clearConnections();
        if (this.hasChildren() && !this.isCollapsed()) {
            this.polyLineConnectionList = this.isHorizontal() ? this.createHorizontalConnections((BPELEditPart)this.getHost()) : this.createVerticalConnections((BPELEditPart)this.getHost());
        }
    }

    public void clearConnections() {
        int i = 0;
        while (i < this.polyLineConnectionList.size()) {
            this.getLayer("Connection Layer").remove((IFigure)this.polyLineConnectionList.get(i));
            ++i;
        }
        this.polyLineConnectionList.clear();
    }

    protected ArrayList<PolylineConnection> createHorizontalConnections(BPELEditPart parent) {
        ArrayList<PolylineConnection> connections = new ArrayList<PolylineConnection>();
        List<BPELEditPart> children = this.getConnectionChildren(parent);
        BPELEditPart sourcePart = parent;
        ConnectionAnchor sourceAnchor = sourcePart.getConnectionAnchor(4);
        if (children != null) {
            int i = 0;
            while (i < children.size()) {
                BPELEditPart targetPart = children.get(i);
                ConnectionAnchor targetAnchor = targetPart.getConnectionAnchor(0);
                connections.add(this.createConnection(sourceAnchor, targetAnchor, this.arrowColor));
                ++i;
            }
        }
        return connections;
    }

    protected List<BPELEditPart> getConnectionChildren(BPELEditPart editPart) {
        return editPart.getChildren();
    }

    protected ArrayList<PolylineConnection> createVerticalConnections(BPELEditPart parent) {
        ArrayList<PolylineConnection> connections = new ArrayList<PolylineConnection>();
        List<BPELEditPart> children = this.getConnectionChildren(parent);
        BPELEditPart sourcePart = null;
        BPELEditPart targetPart = null;
        ConnectionAnchor sourceAnchor = null;
        ConnectionAnchor targetAnchor = null;
        if (!children.isEmpty()) {
            int i = 0;
            while (i <= children.size()) {
                if (i == 0) {
                    if (this.hasTopParentLink()) {
                        sourcePart = parent;
                        sourceAnchor = sourcePart.getConnectionAnchor(4);
                    } else {
                        sourceAnchor = null;
                    }
                } else {
                    sourcePart = children.get(i - 1);
                    sourceAnchor = sourcePart.getConnectionAnchor(1);
                }
                if (i == children.size()) {
                    if (this.hasBottomParentLink()) {
                        targetPart = parent;
                        targetAnchor = targetPart.getConnectionAnchor(5);
                    } else {
                        targetAnchor = null;
                    }
                } else {
                    targetPart = children.get(i);
                    targetAnchor = targetPart.getConnectionAnchor(0);
                }
                if (sourceAnchor != null && targetAnchor != null) {
                    PolylineConnection connection = this.createConnection(sourceAnchor, targetAnchor, this.arrowColor);
                    if (sourcePart instanceof StartNodeEditPart || sourcePart instanceof ScopeEditPart || sourcePart instanceof InvokeEditPart) {
                        boolean horizontal = ModelHelper.isHorizontalLayout(this.getHost().getModel());
                        connection.setConnectionRouter((ConnectionRouter)new ImplicitLinkHandlerConnectionRouter(horizontal));
                    }
                    connections.add(connection);
                }
                ++i;
            }
        }
        return connections;
    }

    protected boolean hasTopParentLink() {
        return !(this.getHost() instanceof ProcessEditPart);
    }

    protected boolean hasBottomParentLink() {
        if (this.getHost() instanceof ProcessEditPart) {
            return false;
        }
        if (this.getHost() instanceof ElseIfEditPart) {
            return false;
        }
        return !(this.getHost() instanceof IfEditPart);
    }

    protected List getSourceParts(Request request) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (request instanceof CreateRequest) {
            list.add(((CreateRequest)request).getNewObject());
        } else if (request instanceof GroupRequest) {
            List l = ((GroupRequest)request).getEditParts();
            for (EditPart editPart : l) {
                list.add(editPart.getModel());
            }
        }
        return list;
    }

    protected LayoutManager getLayoutManager() {
        IFigure figure;
        if (this.getHost() instanceof GraphicalEditPart && (figure = ((GraphicalEditPart)this.getHost()).getContentPane()) != null) {
            return figure.getLayoutManager();
        }
        return null;
    }

    protected boolean canShowFeedback() {
        LayoutManager layout = this.getLayoutManager();
        if (layout == null) {
            return false;
        }
        if (layout instanceof FlowLayout) {
            return true;
        }
        return layout instanceof AlignedFlowLayout;
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (!this.canShowFeedback()) {
            return;
        }
        super.showLayoutTargetFeedback(request);
    }

    public EditPart getTargetEditPart(Request request) {
        if (this.getHost().getRoot() instanceof GraphicalBPELRootEditPart) {
            return super.getTargetEditPart(request);
        }
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return null;
    }

    protected boolean isLayoutHorizontal() {
        return this.isHorizontal();
    }

    protected boolean isHorizontal() {
        LayoutManager layout = this.getLayoutManager();
        if (layout instanceof FlowLayout) {
            return ((FlowLayout)layout).isHorizontal();
        }
        if (layout instanceof AlignedFlowLayout) {
            return ((AlignedFlowLayout)layout).isHorizontal();
        }
        return false;
    }

    protected boolean isCollapsed() {
        if (this.getHost() instanceof CollapsableEditPart) {
            return ((CollapsableEditPart)this.getHost()).isCollapsed();
        }
        return false;
    }

    protected PolylineConnection createConnection(ConnectionAnchor sourceAnchor, ConnectionAnchor targetAnchor, Color color) {
        PolylineConnection connection = new PolylineConnection();
        connection.setSourceAnchor(sourceAnchor);
        connection.setTargetAnchor(targetAnchor);
        connection.setForegroundColor(color);
        connection.setBackgroundColor(color);
        connection.setConnectionRouter((ConnectionRouter)new ImplicitLinkHandlerConnectionRouter(ModelHelper.isHorizontalLayout(this.getHost().getModel())));
        PolygonDecoration arrow = new PolygonDecoration();
        arrow.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        arrow.setScale(5.0, 2.5);
        arrow.setBackgroundColor(this.arrowColor);
        connection.setTargetDecoration((RotatableDecoration)arrow);
        this.getLayer("Connection Layer").add((IFigure)connection);
        return connection;
    }

    public void showTargetFeedback(Request request) {
        if (this.getHost() instanceof BPELEditPart && !((BPELEditPart)this.getHost()).canExecuteRequest(request)) {
            return;
        }
        super.showTargetFeedback(request);
    }

    protected boolean hasChildren() {
        EditPart host = this.getHost();
        return host instanceof ElseIfEditPart || host instanceof CompositeActivityEditPart || host instanceof ProcessEditPart;
    }

    public void deactivate() {
        super.deactivate();
        this.clearConnections();
    }

    public int getFeedbackIndexFor(Request request) {
        return super.getFeedbackIndexFor(request);
    }
}

