/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.Links;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetConstraintCommand;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.CollapsableEditPart;
import org.eclipse.bpel.ui.editparts.LinkEditPart;
import org.eclipse.bpel.ui.editparts.borders.FlowBorder;
import org.eclipse.bpel.ui.editparts.figures.GradientFigure;
import org.eclipse.bpel.ui.editparts.policies.FlowHighlightEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.FlowResizeEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.FlowXYLayoutEditPolicy;
import org.eclipse.bpel.ui.editparts.util.BPELDecorationLayout;
import org.eclipse.bpel.ui.editparts.util.GraphAnimation;
import org.eclipse.bpel.ui.util.BatchedMultiObjectAdapter;
import org.eclipse.bpel.ui.util.FlowXYLayout;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.NonclippingXYLayout;
import org.eclipse.bpel.ui.util.RowColumnLayout;
import org.eclipse.bpel.ui.util.marker.BPELEditPartMarkerDecorator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackListener;

public class FlowEditPart
extends CollapsableEditPart {
    private FlowBorder flowBorder;
    private EContentAdapter flowContentAdapter;
    private BatchedMultiObjectAdapter flowBatchedAdapter;
    protected boolean smoothLayout = false;
    protected FlowHighlightEditPolicy flowHighlightEditPolicy;
    CommandStackListener stackListener = new CommandStackListener(){

        /*
         * Unable to fully structure code
         */
        public void commandStackChanged(EventObject event) {
            if (!FlowEditPart.this.isSmoothLayout()) {
                return;
            }
            FlowEditPart.this.setSmoothLayout(false);
            if (GraphAnimation.captureLayout(FlowEditPart.this.getFigure())) ** GOTO lbl7
            return;
lbl-1000:
            // 1 sources

            {
                FlowEditPart.this.getFigure().getUpdateManager().performUpdate();
lbl7:
                // 2 sources

                ** while (GraphAnimation.step())
            }
lbl8:
            // 1 sources

            GraphAnimation.end();
        }
    };

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        Links links = ((Flow)this.getActivity()).getLinks();
        if (links != null) {
            this.adapter.addToObject((Notifier)links);
        }
    }

    public FlowEditPart() {
        this.flowContentAdapter = new EContentAdapter(){

            public void notifyChanged(Notification n) {
                switch (n.getEventType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        FlowEditPart.this.flowBatchedAdapter.notifyChanged(n);
                    }
                }
                super.notifyChanged(n);
            }
        };
        this.flowBatchedAdapter = new BatchedMultiObjectAdapter(){
            protected boolean refreshLayout = false;

            @Override
            public void finish() {
                if (this.refreshLayout && FlowEditPart.this.getAutoLayout()) {
                    FlowEditPart.this.doAutoLayout(false);
                }
                this.refreshLayout = false;
            }

            @Override
            public void notify(Notification n) {
                if (FlowEditPart.this.isActive()) {
                    this.refreshLayout = true;
                }
            }
        };
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane().add(child, this.getFigure().getLayoutManager().getConstraint(child), index);
    }

    protected void setFlowEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FlowXYLayoutEditPolicy());
        this.flowHighlightEditPolicy = new FlowHighlightEditPolicy(!this.collapsed){

            @Override
            protected int getDrawerInset() {
                return 16;
            }

            @Override
            protected int getNorthInset() {
                if (FlowEditPart.this.isCollapsed()) {
                    return 2;
                }
                return 2;
            }

            @Override
            protected int getSouthInset() {
                return 0;
            }

            @Override
            protected int getEastInset() {
                return 16;
            }

            @Override
            protected int getWestInset() {
                return 18;
            }
        };
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.flowHighlightEditPolicy);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.setFlowEditPolicies();
        this.installEditPolicy("childFlowResize", (EditPolicy)new FlowResizeEditPolicy());
    }

    @Override
    public Label getLabelFigure() {
        if (this.isCollapsed()) {
            return super.getLabelFigure();
        }
        return null;
    }

    @Override
    public void setCollapsed(boolean collapsed) {
        if (collapsed != this.collapsed && this.flowHighlightEditPolicy != null) {
            this.flowHighlightEditPolicy.setResizable(!collapsed);
        }
        super.setCollapsed(collapsed);
    }

    @Override
    protected IFigure createFigure() {
        this.createEditPolicies();
        this.initializeLabels();
        this.editPartMarkerDecorator = new BPELEditPartMarkerDecorator((EObject)this.getModel(), new FlowDecorationLayout());
        this.editPartMarkerDecorator.addMarkerMotionListener(this.getMarkerMotionListener());
        GradientFigure figure = new GradientFigure(this.getModel());
        if (this.collapsed) {
            this.addCollapsedContents((IFigure)figure);
        } else {
            this.configureExpandedFigure((IFigure)figure);
        }
        this.contentFigure = figure;
        return this.editPartMarkerDecorator.createFigure((IFigure)figure);
    }

    @Override
    protected void configureExpandedFigure(IFigure figure) {
        Object layout;
        if (!this.getShowFreeformFlow()) {
            layout = new RowColumnLayout();
        } else {
            FlowXYLayout xylayout = new FlowXYLayout((EditPart)this);
            Dimension d = ModelHelper.getSize((Activity)this.getFlow());
            if (d.height != 0 && d.width != 0) {
                xylayout.setSize(d);
            }
            layout = xylayout;
        }
        figure.setLayoutManager((LayoutManager)layout);
        if (!(figure.getBorder() instanceof FlowBorder)) {
            this.flowBorder = new FlowBorder(figure);
            figure.setBorder((Border)this.flowBorder);
            this.flowBorder.setEditPart(this);
        }
        figure.addMouseMotionListener(this.getMouseMotionListener());
        this.flowBorder.setEditPart(this);
    }

    protected Flow getFlow() {
        return (Flow)this.getModel();
    }

    @Override
    protected boolean isCollapsable() {
        return true;
    }

    @Override
    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        ((Notifier)this.getModel()).eAdapters().remove((Object)this.flowContentAdapter);
        this.getViewer().getEditDomain().getCommandStack().removeCommandStackListener(this.stackListener);
    }

    private boolean getShowFreeformFlow() {
        return BPELUIPlugin.INSTANCE.getPreferenceStore().getBoolean("pref_show_freeform_flow");
    }

    private boolean getAutoLayout() {
        return BPELUIPlugin.INSTANCE.getPreferenceStore().getBoolean("pref_auto_flow_layout");
    }

    @Override
    public IFigure getContentPane() {
        return this.contentFigure;
    }

    public boolean isShowFreeform() {
        return this.getContentPane().getLayoutManager() instanceof NonclippingXYLayout;
    }

    @Override
    public void regenerateVisuals() {
        if (this.collapsed) {
            this.addCollapsedContents(this.contentFigure);
        } else {
            this.configureExpandedFigure(this.contentFigure);
        }
        this.setFlowEditPolicies();
        this.refreshDrawerImages();
        if (this.getShowFreeformFlow() && this.getAutoLayout()) {
            this.doAutoLayout(false);
        }
    }

    public DirectedGraph computeAutoLayoutGraph(Map partsToNodes) {
        DirectedGraph graph = new DirectedGraph();
        graph.setDefaultPadding(new Insets(8, 8, 10, 8));
        Node top = new Node(null);
        graph.nodes.add((Object)top);
        top.height = 0;
        top.width = 0;
        top.setPadding(new Insets(-8, 0, 0, 0));
        ArrayList<Node> nodesWithoutPreds = new ArrayList<Node>();
        for (Object object : this.getChildren()) {
            if (!(object instanceof BPELEditPart)) continue;
            BPELEditPart editPart = (BPELEditPart)object;
            Node n = new Node((Object)editPart);
            n.width = editPart.getFigure().getPreferredSize().width;
            n.height = editPart.getFigure().getPreferredSize().height;
            n.sortValue = this.getFigure().getBounds().x;
            graph.nodes.add((Object)n);
            partsToNodes.put(editPart, n);
            nodesWithoutPreds.add(n);
        }
        for (Object object : this.getChildren()) {
            Node target;
            if (!(object instanceof BPELEditPart) || (target = (Node)partsToNodes.get(object)) == null) continue;
            for (Object object2 : ((BPELEditPart)object).getTargetConnections()) {
                LinkEditPart link;
                Node source;
                if (!(object2 instanceof LinkEditPart) || (source = (Node)partsToNodes.get((link = (LinkEditPart)((Object)object2)).getSource())) == null) continue;
                graph.edges.add((Object)new Edge(source, target));
                nodesWithoutPreds.remove(target);
            }
        }
        Iterator it = nodesWithoutPreds.iterator();
        while (it.hasNext()) {
            graph.edges.add((Object)new Edge(top, (Node)it.next()));
        }
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public void doImmediateAutoLayout() {
        HashMap partsToNodes = new HashMap();
        if (BPELUIPlugin.INSTANCE.getPreferenceStore().getBoolean("pref_use_animation")) {
            this.setSmoothLayout(true);
        }
        this.computeAutoLayoutGraph(partsToNodes);
        for (Object object : this.getChildren()) {
            if (!(object instanceof BPELEditPart)) continue;
            BPELEditPart editPart = (BPELEditPart)object;
            Node n = (Node)partsToNodes.get(editPart);
            Point loc = new Point(n.x, n.y);
            ModelHelper.setLocation((Activity)editPart.getModel(), loc);
        }
    }

    public void doAutoLayout() {
        this.doAutoLayout(true);
    }

    public void doAutoLayout(boolean withCommand) {
        HashMap partsToNodes = new HashMap();
        this.getFigure().invalidateTree();
        if (BPELUIPlugin.INSTANCE.getPreferenceStore().getBoolean("pref_use_animation")) {
            this.setSmoothLayout(true);
        }
        this.computeAutoLayoutGraph(partsToNodes);
        CompoundCommand cmd = new CompoundCommand();
        cmd.setLabel(IBPELUIConstants.CMD_AUTO_ARRANGE);
        BPELEditor bpelEditor = ModelHelper.getBPELEditor(this.getModel());
        for (Object object : this.getChildren()) {
            if (!(object instanceof BPELEditPart)) continue;
            BPELEditPart editPart = (BPELEditPart)object;
            Node n = (Node)partsToNodes.get(editPart);
            Point loc = new Point(n.x, n.y);
            SetConstraintCommand cmd2 = new SetConstraintCommand((Activity)editPart.getModel(), loc, null);
            if (withCommand) {
                cmd.add((Command)cmd2);
                continue;
            }
            cmd2.execute();
        }
        if (withCommand) {
            this.regenerateVisuals();
            bpelEditor.getCommandStack().execute((Command)cmd);
        }
    }

    @Override
    protected void handleModelChanged() {
        this.refreshChildren();
        super.handleModelChanged();
        this.regenerateVisuals();
    }

    @Override
    public void activate() {
        super.activate();
        ((Notifier)this.getModel()).eAdapters().add((Object)this.flowContentAdapter);
        this.getViewer().getEditDomain().getCommandStack().addCommandStackListener(this.stackListener);
    }

    public boolean isSmoothLayout() {
        return this.smoothLayout;
    }

    public void setSmoothLayout(boolean smoothLayout) {
        this.smoothLayout = smoothLayout;
    }

    public boolean detectImpendingCycle(EditPart sourceNode, EditPart potentialDest) {
        EditPartNode target;
        ArrayList<EditPartNode> nodes = new ArrayList<EditPartNode>();
        HashMap<BPELEditPart, EditPartNode> partsToNodes = new HashMap<BPELEditPart, EditPartNode>();
        for (Object object : this.getChildren()) {
            if (!(object instanceof BPELEditPart)) continue;
            BPELEditPart editPart = (BPELEditPart)object;
            EditPartNode n = new EditPartNode((EditPart)editPart);
            nodes.add(n);
            partsToNodes.put(editPart, n);
        }
        for (Object object : this.getChildren()) {
            EditPartNode source;
            if (!(object instanceof BPELEditPart) || (source = (EditPartNode)partsToNodes.get(object)) == null) continue;
            for (Object targetObject : ((BPELEditPart)object).getSourceConnections()) {
                LinkEditPart linkEditPart;
                EditPartNode target2;
                if (!(targetObject instanceof LinkEditPart) || (target2 = (EditPartNode)partsToNodes.get((linkEditPart = (LinkEditPart)((Object)targetObject)).getTarget())) == null) continue;
                source.addEdge(new EditPartEdge(source, target2));
            }
        }
        EditPartNode source = (EditPartNode)partsToNodes.get(sourceNode);
        if (source != null && (target = (EditPartNode)partsToNodes.get(potentialDest)) != null) {
            source.addEdge(new EditPartEdge(source, target));
        }
        for (EditPartNode v : nodes) {
            if (v.getVisited() != 0 || v.visit()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void switchLayout(boolean horizontal) {
    }

    private class EditPartEdge {
        private EditPartNode source;
        private EditPartNode dest;

        public EditPartEdge(EditPartNode source, EditPartNode dest) {
            this.source = source;
            this.dest = dest;
        }

        public EditPartNode getDest() {
            return this.dest;
        }

        public EditPartNode getSource() {
            return this.source;
        }
    }

    private class EditPartNode {
        public static final int VISITING = 1;
        public static final int VISITED = 2;
        public static final int NOTVISITED = 0;
        private EditPart part;
        private List edges = new ArrayList();
        public int visited = 0;

        public EditPartNode(EditPart part) {
            this.part = part;
        }

        public EditPart getPart() {
            return this.part;
        }

        public int getVisited() {
            return this.visited;
        }

        public void addEdge(EditPartEdge edge) {
            this.edges.add(edge);
        }

        public boolean visit() {
            if (this.visited == 1) {
                return false;
            }
            if (this.visited == 2) {
                return true;
            }
            this.visited = 1;
            for (EditPartEdge e : this.edges) {
                if (e.getDest().visit()) continue;
                return false;
            }
            this.visited = 2;
            return true;
        }
    }

    class FlowDecorationLayout
    extends BPELDecorationLayout {
        FlowDecorationLayout() {
        }

        protected Point calculateLocation(int locationHint, IFigure container, Dimension childDimension) {
            Rectangle area = container.getClientArea();
            switch (locationHint) {
                case 2: {
                    return new Point(area.x + area.width / 2 - childDimension.width / 2, area.y + area.height / 2 - childDimension.height / 2);
                }
                case 8: {
                    return new Point(area.x + area.width / 2 - childDimension.width / 2, area.y + 2);
                }
                case 32: {
                    return new Point(area.x + area.width / 2 - childDimension.width / 2, area.y + area.height - childDimension.height - 2);
                }
                case 1: {
                    int x = area.x + 16;
                    int y = area.y;
                    y = FlowEditPart.this.isCollapsed() ? (y += container.getBounds().height / 2) : (y += area.height / 2 - childDimension.width / 2);
                    return new Point(x, y);
                }
                case 4: {
                    int x = area.x + area.width - 16 - childDimension.width;
                    int y = area.y;
                    y = FlowEditPart.this.isCollapsed() ? (y += container.getBounds().height / 2) : (y += area.height / 2 - childDimension.width / 2);
                    return new Point(x, y);
                }
                case 9: {
                    int x = area.x + 16;
                    int y = area.y;
                    if (FlowEditPart.this.isCollapsed()) {
                        y += FlowEditPart.this.image.getBounds().height / 2;
                    }
                    return new Point(x, y);
                }
                case 12: {
                    int x = area.x + area.width - 16 - childDimension.width;
                    int y = area.y;
                    if (FlowEditPart.this.isCollapsed()) {
                        y += FlowEditPart.this.image.getBounds().height / 2;
                    }
                    return new Point(x, y);
                }
                case 33: {
                    int x = area.x + 16;
                    int y = area.y + area.height - FlowEditPart.this.image.getBounds().height / 2;
                    return new Point(x, y);
                }
                case 36: {
                    int x = area.x + area.width - 16 - childDimension.width;
                    int y = area.y + area.height - FlowEditPart.this.image.getBounds().height / 2;
                    return new Point(x, y);
                }
            }
            return new Point(area.x, area.y);
        }
    }
}

