/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SaveImageDialog
extends TrayDialog {
    private static final String SETTINGS_IS_TRANSPARENT = "Transparent";
    private static final String SETTINGS_DIRECTORY = "Directory";
    private Text txtImageFileName;
    private Button btnTransparent;
    private String fileNamePart;
    private String imageFileName;
    private boolean transparent;
    private IDialogSettings settings;

    public SaveImageDialog(Shell parentShell, String filename) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.fileNamePart = this.stripExtenstion(filename);
        this.settings = BPELUIPlugin.INSTANCE.getDialogSettingsFor((Object)this);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Export as image");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 3;
        new Label(composite, 0).setText("To image file:");
        this.txtImageFileName = new Text(composite, 2048);
        this.txtImageFileName.setLayoutData((Object)new GridData(768));
        this.txtImageFileName.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                SaveImageDialog.this.btnTransparent.setEnabled(SaveImageDialog.this.txtImageFileName.getText().endsWith(".png"));
            }
        });
        Button browseButton = new Button(composite, 0);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveImageDialog.this.selectFile();
            }
        });
        this.btnTransparent = new Button(composite, 32);
        this.btnTransparent.setText("Transparent background");
        GridData gd = new GridData();
        gd.widthHint = 400;
        gd.horizontalSpan = 3;
        this.btnTransparent.setLayoutData((Object)gd);
        this.applySettings();
        return composite;
    }

    private void applySettings() {
        String dir = this.settings.get(SETTINGS_DIRECTORY);
        if (dir != null) {
            this.txtImageFileName.setText(new Path(dir).append(this.fileNamePart).addFileExtension("png").toOSString());
        }
        this.btnTransparent.setSelection(this.settings.getBoolean(SETTINGS_IS_TRANSPARENT));
    }

    private void selectFile() {
        String[] filterExtensions = new String[]{"*.png", "*.jpg", "*.bmp"};
        String[] filterNames = new String[]{"PNG (*.png)", "JPEG (*.jpg)", "BMP (*.bmp)"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setFilterPath(this.txtImageFileName.getText());
        fileDialog.setFileName(this.fileNamePart);
        fileDialog.setFilterNames(filterNames);
        fileDialog.setFilterExtensions(filterExtensions);
        fileDialog.setText("Export as");
        String result = fileDialog.open();
        if (result != null) {
            this.txtImageFileName.setText(result);
        }
    }

    private String stripExtenstion(String fileName) {
        int pos = fileName.lastIndexOf(46);
        return pos == -1 ? fileName : fileName.substring(0, pos);
    }

    public String getFileName() {
        return this.imageFileName;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    protected void okPressed() {
        this.imageFileName = this.txtImageFileName.getText();
        this.transparent = this.btnTransparent.getSelection();
        this.settings.put(SETTINGS_IS_TRANSPARENT, this.transparent);
        this.settings.put(SETTINGS_DIRECTORY, new Path(this.imageFileName).removeLastSegments(1).toString());
        super.okPressed();
    }
}

