/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.EasingFunctionBase;

public class PowerEase
extends EasingFunctionBase {
    private double power = 2.0;

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    @Override
    public double ease(double normalizedTime) {
        switch (this.getEasingMode()) {
            case EaseIn: {
                return Math.pow(normalizedTime, this.getPower());
            }
            case EaseOut: {
                return 1.0 - Math.pow(1.0 - normalizedTime, this.getPower());
            }
            case EaseInOut: {
                normalizedTime /= 0.5;
                if (normalizedTime < 1.0) {
                    return Math.pow(normalizedTime, this.getPower()) / 2.0;
                }
                return (2.0 - Math.pow(2.0 - normalizedTime, this.getPower())) / 2.0;
            }
        }
        throw new XWTException(String.valueOf(this.getEasingMode().name()) + " is supported.");
    }
}

