/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.ui;

import org.eclipse.xtext.junit4.ui.AbstractAutoEditTest;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.junit.Ignore;
import org.junit.Test;

@Deprecated
public abstract class AbstractCStyleLanguageAutoEditTest
extends AbstractAutoEditTest {
    @Test
    public void testParenthesis_1() throws Exception {
        XtextEditor editor = this.openEditor("|");
        this.pressKey(editor, '(');
        this.assertState("(|)", editor);
        this.pressKey(editor, '(');
        this.assertState("((|))", editor);
        this.pressKey(editor, '\b');
        this.assertState("(|)", editor);
        this.pressKey(editor, '\b');
        this.assertState("|", editor);
    }

    @Test
    public void testParenthesis_2() throws Exception {
        XtextEditor editor = this.openEditor("|");
        this.pressKey(editor, '(');
        this.assertState("(|)", editor);
        this.pressKey(editor, ')');
        this.assertState("()|", editor);
        this.pressKey(editor, '\b');
        this.assertState("(|", editor);
        this.pressKey(editor, '\b');
        this.assertState("|", editor);
    }

    @Test
    public void testParenthesis_3() throws Exception {
        XtextEditor editor = this.openEditor("|)");
        this.pressKey(editor, '(');
        this.assertState("(|)", editor);
        this.pressKey(editor, '\b');
        this.assertState("|", editor);
    }

    @Test
    public void testParenthesis_4() throws Exception {
        XtextEditor editor = this.openEditor("|foobar");
        this.pressKey(editor, '(');
        this.assertState("(|foobar", editor);
    }

    @Test
    public void testParenthesis_5() throws Exception {
        XtextEditor editor = this.openEditor("|");
        this.pressKey(editor, ')');
        this.assertState(")|", editor);
        this.pressKey(editor, ')');
        this.assertState("))|", editor);
        this.pressKey(editor, '\b');
        this.assertState(")|", editor);
        this.pressKey(editor, '\b');
        this.assertState("|", editor);
    }

    @Test
    public void testParenthesis_6() throws Exception {
        XtextEditor editor = this.openEditor("(|\n)");
        this.pressKey(editor, ')');
        this.assertState("()|\n)", editor);
        this.pressKey(editor, '\b');
        this.assertState("(|\n)", editor);
    }

    @Test
    public void testParenthesis_7() throws Exception {
        XtextEditor editor = this.openEditor("(((|)");
        this.pressKey(editor, ')');
        this.assertState("((()|)", editor);
        this.pressKey(editor, ')');
        this.assertState("((())|)", editor);
        this.pressKey(editor, ')');
        this.assertState("((()))|", editor);
    }

    @Test
    public void testParenthesis_8() throws Exception {
        XtextEditor editor = this.openEditor("(foobar|)");
        this.pressKey(editor, ')');
        this.assertState("(foobar)|", editor);
    }

    @Ignore
    @Test
    public void testParenthesis_9() throws Exception {
        XtextEditor editor = this.openEditor("|'')");
        this.pressKey(editor, '(');
        this.assertState("(|'')", editor);
    }

    @Test
    public void testParenthesis_10() throws Exception {
        XtextEditor editor = this.openEditor("(|'')");
        this.pressKey(editor, '(');
        this.assertState("((|'')", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_1() throws Exception {
        XtextEditor editor = this.openEditor("|");
        this.pressKey(editor, '\'');
        this.assertState("'|'", editor);
        this.pressKey(editor, '\b');
        this.assertState("|", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_2() throws Exception {
        XtextEditor editor = this.openEditor("|");
        this.pressKey(editor, '\'');
        this.assertState("'|'", editor);
        this.pressKey(editor, '\'');
        this.assertState("''|", editor);
        this.pressKey(editor, '\b');
        this.assertState("'|", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_3() throws Exception {
        XtextEditor editor = this.openEditor("|'");
        this.pressKey(editor, '\'');
        this.assertState("'|'", editor);
        this.pressKey(editor, '\'');
        this.assertState("''|", editor);
        this.pressKey(editor, '\'');
        this.assertState("'''|'", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_4() throws Exception {
        XtextEditor editor = this.openEditor("|foo");
        this.pressKey(editor, '\'');
        this.assertState("'|foo", editor);
        this.pressKey(editor, '\'');
        this.assertState("''|foo", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_5() throws Exception {
        XtextEditor editor = this.openEditor("|foo");
        this.pressKey(editor, '\'');
        this.assertState("'|foo", editor);
        this.pressKey(editor, '\'');
        this.assertState("''|foo", editor);
        this.pressKey(editor, '\b');
        this.assertState("'|foo", editor);
        this.pressKey(editor, '\b');
        this.assertState("|foo", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_6() throws Exception {
        XtextEditor editor = this.openEditor("'| '");
        this.pressKey(editor, '\'');
        this.assertState("''| '", editor);
        this.pressKey(editor, '\b');
        this.assertState("'| '", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_7() throws Exception {
        XtextEditor editor = this.openEditor("'' '| '");
        this.pressKey(editor, '\'');
        this.assertState("'' ''| '", editor);
        this.pressKey(editor, '\b');
        this.assertState("'' '| '", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_8() throws Exception {
        XtextEditor editor = this.openEditor("'| ' ' '");
        this.pressKey(editor, '\'');
        this.assertState("''| ' ' '", editor);
        this.pressKey(editor, '\b');
        this.assertState("'| ' ' '", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_9() throws Exception {
        XtextEditor editor = this.openEditor("foo|{}");
        this.selectText(editor, -3, 3);
        this.pressKey(editor, '\'');
        this.assertState("'|'{}", editor);
        this.pressKey(editor, '\b');
        this.assertState("|{}", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_10() throws Exception {
        XtextEditor editor = this.openEditor("foo|{}");
        this.selectText(editor, -2, 2);
        this.pressKey(editor, '\'');
        this.assertState("f'|'{}", editor);
        this.pressKey(editor, '\b');
        this.assertState("f|{}", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_11() throws Exception {
        XtextEditor editor = this.openEditor("|foo{}");
        this.selectText(editor, 0, 2);
        this.pressKey(editor, '\'');
        this.assertState("'|o{}", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_12() throws Exception {
        XtextEditor editor = this.openEditor("|foo{}");
        this.selectText(editor, 0, 1);
        this.pressKey(editor, '\'');
        this.assertState("'|oo{}", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_13() throws Exception {
        XtextEditor editor = this.openEditor("'a|");
        this.pressKey(editor, '\'');
        this.assertState("'a'|", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_14() throws Exception {
        XtextEditor editor = this.openEditor("|'test'");
        this.pressKey(editor, '\'');
        this.assertState("'|''test'", editor);
        this.pressKey(editor, '\'');
        this.assertState("''|'test'", editor);
        this.pressKey(editor, '\'');
        this.assertState("'''|''test'", editor);
    }

    @Test
    public void testSingleQuotedStringLiteral_15() throws Exception {
        XtextEditor editor = this.openEditor("'|''test'");
        this.pressKey(editor, '\'');
        this.assertState("''|'test'", editor);
        this.pressKey(editor, '\'');
        this.assertState("'''|''test'", editor);
    }

    @Test
    public void testDoubleQuotedStringLiteral_1() throws Exception {
        XtextEditor editor = this.openEditor("|");
        this.pressKey(editor, '\"');
        this.assertState("\"|\"", editor);
        this.pressKey(editor, '\b');
        this.assertState("|", editor);
    }

    @Test
    public void testDoubleQuotedStringLiteral_2() throws Exception {
        XtextEditor editor = this.openEditor("|");
        this.pressKey(editor, '\"');
        this.assertState("\"|\"", editor);
        this.pressKey(editor, '\"');
        this.assertState("\"\"|", editor);
        this.pressKey(editor, '\b');
        this.assertState("\"|", editor);
    }

    @Test
    public void testDoubleQuotedStringLiteral_3() throws Exception {
        XtextEditor editor = this.openEditor("|\"");
        this.pressKey(editor, '\"');
        this.assertState("\"|\"", editor);
        this.pressKey(editor, '\"');
        this.assertState("\"\"|", editor);
        this.pressKey(editor, '\"');
        this.assertState("\"\"\"|\"", editor);
    }

    @Test
    public void testDoubleQuotedStringLiteral_4() throws Exception {
        XtextEditor editor = this.openEditor("|foo");
        this.pressKey(editor, '\"');
        this.assertState("\"|foo", editor);
        this.pressKey(editor, '\"');
        this.assertState("\"\"|foo", editor);
    }

    @Test
    public void testDoubleQuotedStringLiteral_5() throws Exception {
        XtextEditor editor = this.openEditor("|foo");
        this.pressKey(editor, '\"');
        this.assertState("\"|foo", editor);
        this.pressKey(editor, '\"');
        this.assertState("\"\"|foo", editor);
        this.pressKey(editor, '\b');
        this.assertState("\"|foo", editor);
        this.pressKey(editor, '\b');
        this.assertState("|foo", editor);
    }

    @Test
    public void testDoubleQuotedStringLiteral_6() throws Exception {
        XtextEditor editor = this.openEditor("\"| \"");
        this.pressKey(editor, '\"');
        this.assertState("\"\"| \"", editor);
        this.pressKey(editor, '\b');
        this.assertState("\"| \"", editor);
    }

    @Test
    public void testDoubleQuotedStringLiteral_7() throws Exception {
        XtextEditor editor = this.openEditor("\"\" \"| \"");
        this.pressKey(editor, '\"');
        this.assertState("\"\" \"\"| \"", editor);
        this.pressKey(editor, '\b');
        this.assertState("\"\" \"| \"", editor);
    }

    @Test
    public void testDoubleQuotedStringLiteral_8() throws Exception {
        XtextEditor editor = this.openEditor("\"| \" \" \"");
        this.pressKey(editor, '\"');
        this.assertState("\"\"| \" \" \"", editor);
        this.pressKey(editor, '\b');
        this.assertState("\"| \" \" \"", editor);
    }

    @Test
    public void testDoubleQuotedStringLiteral_9() throws Exception {
        XtextEditor editor = this.openEditor("\"a|");
        this.pressKey(editor, '\"');
        this.assertState("\"a\"|", editor);
    }

    @Test
    public void testDoubleQuotedStringLiteral_10() throws Exception {
        XtextEditor editor = this.openEditor("|\"test\"");
        this.pressKey(editor, '\"');
        this.assertState("\"|\"\"test\"", editor);
    }

    @Test
    public void testCurlyBracesBlock_1() throws Exception {
        XtextEditor editor = this.openEditor("|");
        this.pressKey(editor, '{');
        this.assertState("{|}", editor);
        this.pressKey(editor, '\n');
        this.assertState("{\n\t|\n}", editor);
        this.pressKey(editor, '\n');
        this.assertState("{\n\t\n\t|\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_2() throws Exception {
        XtextEditor editor = this.openEditor("{|\n}");
        this.pressKey(editor, '\n');
        this.assertState("{\n\t|\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_3() throws Exception {
        XtextEditor editor = this.openEditor("|");
        this.pressKey(editor, '}');
        this.assertState("}|", editor);
    }

    @Test
    public void testCurlyBracesBlock_4() throws Exception {
        XtextEditor editor = this.openEditor("foo {|");
        this.pressKey(editor, '\n');
        this.assertState("foo {\n\t|\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_5() throws Exception {
        XtextEditor editor = this.openEditor("{|}");
        this.pressKey(editor, '\n');
        this.assertState("{\n\t|\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_6() throws Exception {
        XtextEditor editor = this.openEditor("{| }");
        this.pressKey(editor, '\n');
        this.assertState("{\n\t|\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_7() throws Exception {
        XtextEditor editor = this.openEditor("{ |foo }");
        this.pressKey(editor, '\n');
        this.assertState("{ \n\t|foo\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_8() throws Exception {
        XtextEditor editor = this.openEditor("{ foo| }");
        this.pressKey(editor, '\n');
        this.assertState("{ foo\n\t|\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_9() throws Exception {
        XtextEditor editor = this.openEditor("'{' foo| }");
        this.pressKey(editor, '\n');
        this.assertState("'{' foo\n| }", editor);
    }

    @Test
    public void testCurlyBracesBlock_10() throws Exception {
        XtextEditor editor = this.openEditor("/*{*/ foo|");
        this.pressKey(editor, '\n');
        this.assertState("/*{*/ foo\n|", editor);
    }

    @Test
    public void testCurlyBracesBlock_11() throws Exception {
        XtextEditor editor = this.openEditor("{|}");
        this.pressKey(editor, '\n');
        this.assertState("{\n\t|\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_12() throws Exception {
        XtextEditor editor = this.openEditor("{foo|}");
        this.pressKey(editor, '\n');
        this.assertState("{foo\n\t|\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_13() throws Exception {
        XtextEditor editor = this.openEditor("{foo|bar}");
        this.pressKey(editor, '\n');
        this.assertState("{foo\n\t|bar\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_14() throws Exception {
        XtextEditor editor = this.openEditor("{\nfoo|bar}");
        this.pressKey(editor, '\n');
        this.assertState("{\nfoo\n|bar}", editor);
    }

    @Test
    public void testCurlyBracesBlock_15() throws Exception {
        XtextEditor editor = this.openEditor("{\nfoo}|{bar}");
        this.pressKey(editor, '\n');
        this.assertState("{\nfoo}\n|{bar}", editor);
    }

    @Test
    public void testCurlyBracesBlock_16() throws Exception {
        XtextEditor editor = this.openEditor("{\n|}");
        this.pressKey(editor, '\n');
        this.assertState("{\n\n|}", editor);
    }

    @Test
    public void testCurlyBracesBlock_17() throws Exception {
        XtextEditor editor = this.openEditor("{\n|");
        this.pressKey(editor, '\n');
        this.assertState("{\n\n|\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_18() throws Exception {
        XtextEditor editor = this.openEditor("{{foo}|{bar}}");
        this.pressKey(editor, '\n');
        this.assertState("{{foo}\n\t|{bar}\n}", editor);
    }

    @Test
    public void testCurlyBracesBlock_19() throws Exception {
        XtextEditor editor = this.openEditor("{{|");
        this.pressKey(editor, '\n');
        this.assertState("{{\n\t|\n}", editor);
        this.pressKey(editor, '\n');
        this.assertState("{{\n\t\n\t|\n\t}\n}", editor);
        this.pressKey(editor, '\n');
        this.assertState("{{\n\t\n\t\n\t|\n\t}\n}", editor);
    }

    @Test
    public void testCurlyBracesWithSelection_1() throws Exception {
        XtextEditor editor = this.openEditor("{|foo}");
        this.selectText(editor, 0, 3);
        this.pressKey(editor, '{');
        this.assertState("{{|}}", editor);
        this.pressKey(editor, '\b');
        this.assertState("{|}", editor);
    }

    @Test
    public void testCurlyBracesWithSelection_2() throws Exception {
        XtextEditor editor = this.openEditor("{|foo}");
        this.selectText(editor, 0, 2);
        this.pressKey(editor, '{');
        this.assertState("{{|o}", editor);
        this.pressKey(editor, '\b');
        this.assertState("{|o}", editor);
    }

    @Test
    public void testCurlyBracesWithSelection_3() throws Exception {
        XtextEditor editor = this.openEditor("{|foo}");
        this.selectText(editor, 0, 1);
        this.pressKey(editor, '{');
        this.assertState("{{|oo}", editor);
        this.pressKey(editor, '\b');
        this.assertState("{|oo}", editor);
    }

    @Test
    public void testCurlyBracesWithSelection_4() throws Exception {
        XtextEditor editor = this.openEditor("{{|foo}}");
        this.selectText(editor, 0, 3);
        this.pressKey(editor, '}');
        this.assertState("{{}|}", editor);
        this.pressKey(editor, '\b');
        this.assertState("{{|}", editor);
    }

    @Test
    public void testCurlyBracesWithSelection_5() throws Exception {
        XtextEditor editor = this.openEditor("{{|foo}}");
        this.selectText(editor, 0, 2);
        this.pressKey(editor, '}');
        this.assertState("{{}|o}}", editor);
        this.pressKey(editor, '\b');
        this.assertState("{{|o}}", editor);
        this.pressKey(editor, '{');
        this.assertState("{{{|o}}", editor);
    }

    @Test
    public void testMLComments_01() throws Exception {
        XtextEditor editor = this.openEditor("|");
        this.pressKey(editor, '/');
        this.pressKey(editor, '*');
        this.assertState("/*| */", editor);
        this.pressKey(editor, '\n');
        this.assertState("/*\n * |\n */", editor);
        this.pressKey(editor, '\n');
        this.assertState("/*\n * \n * |\n */", editor);
        this.pressKeys(editor, "foo bar");
        this.pressKey(editor, '\n');
        this.assertState("/*\n * \n * foo bar\n * |\n */", editor);
    }

    @Test
    public void testMLComments_02() throws Exception {
        XtextEditor editor = this.openEditor("   |");
        this.pressKey(editor, '/');
        this.pressKey(editor, '*');
        this.assertState("   /*| */", editor);
        this.pressKey(editor, '\n');
        this.assertState("   /*\n    * |\n    */", editor);
        this.pressKey(editor, '\n');
        this.assertState("   /*\n    * \n    * |\n    */", editor);
        this.pressKeys(editor, "foo bar");
        this.pressKey(editor, '\n');
        this.assertState("   /*\n    * \n    * foo bar\n    * |\n    */", editor);
    }

    @Test
    public void testMLComments_03() throws Exception {
        XtextEditor editor = this.openEditor("/*\n *| */");
        this.pressKey(editor, '\n');
        this.assertState("/*\n *\n * | */", editor);
    }

    @Test
    public void testMLComments_04() throws Exception {
        XtextEditor editor = this.openEditor("\t/*\n\t *|\n\t */");
        this.pressKey(editor, '\n');
        this.assertState("\t/*\n\t *\n\t * |\n\t */", editor);
    }

    @Test
    public void testMLComments_05() throws Exception {
        XtextEditor editor = this.openEditor("foo /*\n     *|\n      */");
        this.pressKey(editor, '\n');
        this.assertState("foo /*\n     *\n     * |\n      */", editor);
    }

    @Test
    public void testMLComments_07() throws Exception {
        XtextEditor editor = this.openEditor("/* */|");
        this.pressKey(editor, '\n');
        this.assertState("/* */\n|", editor);
    }

    @Test
    public void testMLComments_08() throws Exception {
        XtextEditor editor = this.openEditor("  /* foo | */");
        this.pressKey(editor, '\n');
        this.assertState("  /* foo \n   * |\n   */", editor);
    }

    @Test
    public void testMLComments_09() throws Exception {
        XtextEditor editor = this.openEditor("/* foo |*/");
        this.pressKey(editor, '\n');
        this.assertState("/* foo \n * |*/", editor);
    }

    @Test
    public void testMLComments_10() throws Exception {
        XtextEditor editor = this.openEditor("   /* foo |*/");
        this.pressKey(editor, '\n');
        this.assertState("   /* foo \n    * |*/", editor);
    }

    @Test
    public void testMLComments_11() throws Exception {
        XtextEditor editor = this.openEditor("/* */\n * |");
        this.pressKey(editor, '\n');
        this.assertState("/* */\n * \n |", editor);
    }

    @Test
    public void testMLComments_12() throws Exception {
        XtextEditor editor = this.openEditor("foo /*| */");
        this.pressKey(editor, '\n');
        this.assertState("foo /*\n * |\n */", editor);
    }

    @Test
    public void testMLComments_13() throws Exception {
        XtextEditor editor = this.openEditor("/* foo| */");
        this.pressKey(editor, '\n');
        this.assertState("/* foo\n * |\n */", editor);
    }

    @Test
    public void testMLComments_14() throws Exception {
        XtextEditor editor = this.openEditor("/* foo|*/");
        this.pressKey(editor, '\n');
        this.assertState("/* foo\n * |*/", editor);
    }

    @Test
    public void testMLComments_15() throws Exception {
        XtextEditor editor = this.openEditor("  /* foo| */");
        this.pressKey(editor, '\n');
        this.assertState("  /* foo\n   * |\n   */", editor);
    }

    @Test
    public void testMLComments_16() throws Exception {
        XtextEditor editor = this.openEditor("  /* foo|*/");
        this.pressKey(editor, '\n');
        this.assertState("  /* foo\n   * |*/", editor);
    }

    @Test
    public void testMLComments_17() throws Exception {
        XtextEditor editor = this.openEditor("  /*\n| *\n */");
        this.pressKey(editor, '\n');
        this.assertState("  /*\n\n| *\n */", editor);
    }

    @Test
    public void testBug453205_01() throws Exception {
        XtextEditor editor = this.openEditor("/*|\n* comment\n*/");
        this.pressKey(editor, '\n');
        this.assertState("/*\n * |\n* comment\n*/", editor);
    }

    @Test
    public void testBug453205_02() throws Exception {
        XtextEditor editor = this.openEditor("/**********|\n * \"Fancy\"\n**********/");
        this.pressKey(editor, '\n');
        this.assertState("/**********\n * |\n * \"Fancy\"\n**********/", editor);
    }

    @Test
    public void testBug341093_01() throws Exception {
        XtextEditor editor = this.openEditor("/**/\n//test|");
        this.pressKey(editor, '\n');
        this.assertState("/**/\n//test\n|", editor);
    }

    @Test
    public void testBug341093_02() throws Exception {
        XtextEditor editor = this.openEditor("/*\n **/\n//test|");
        this.pressKey(editor, '\n');
        this.assertState("/*\n **/\n//test\n|", editor);
    }

    @Test
    public void testBug341093_03() throws Exception {
        XtextEditor editor = this.openEditor("/***********\n * text|\n\n***********/");
        this.pressKey(editor, '\n');
        this.assertState("/***********\n * text\n * |\n\n***********/", editor);
    }

    @Test
    public void testBug335634_01() throws Exception {
        XtextEditor editor = this.openEditor("// /*|\ntest");
        this.pressKey(editor, '\n');
        this.assertState("// /*\n|\ntest", editor);
    }

    @Test
    public void testBug335634_02() throws Exception {
        XtextEditor editor = this.openEditor("// /|");
        this.pressKey(editor, '*');
        this.assertState("// /*|", editor);
    }

    @Test
    public void testBug335634_03() throws Exception {
        XtextEditor editor = this.openEditor(" // /|");
        this.pressKey(editor, '*');
        this.assertState(" // /*|", editor);
    }

    @Test
    public void testBug335634_04() throws Exception {
        XtextEditor editor = this.openEditor(" // /|\n");
        this.pressKey(editor, '*');
        this.assertState(" // /*|\n", editor);
    }

    @Test
    public void testBug335634_05() throws Exception {
        XtextEditor editor = this.openEditor("// /|");
        this.pressKey(editor, '{');
        this.assertState("// /{|", editor);
    }

    @Test
    public void testBug335634_06() throws Exception {
        XtextEditor editor = this.openEditor(" // /|");
        this.pressKey(editor, '{');
        this.assertState(" // /{|", editor);
    }

    @Test
    public void testBug335634_07() throws Exception {
        XtextEditor editor = this.openEditor(" // /\n|");
        this.pressKey(editor, '{');
        this.assertState(" // /\n{|}", editor);
    }

    @Test
    public void testSingleLineComment_01() throws Exception {
        XtextEditor editor = this.openEditor("  // test|test");
        this.pressKey(editor, '\n');
        this.assertState("  // test\n  |test", editor);
    }

    @Test
    public void testSingleLineComment_02() throws Exception {
        XtextEditor editor = this.openEditor("  // test|test\n");
        this.pressKey(editor, '\n');
        this.assertState("  // test\n  |test\n", editor);
    }

    @Test
    public void testSingleLineComment_03() throws Exception {
        XtextEditor editor = this.openEditor("  // test|");
        this.pressKey(editor, '\n');
        this.assertState("  // test\n  |", editor);
    }

    @Test
    public void testSingleLineComment_04() throws Exception {
        XtextEditor editor = this.openEditor("  // test|\n");
        this.pressKey(editor, '\n');
        this.assertState("  // test\n  |\n", editor);
    }

    @Test
    public void testBug338423_01() throws Exception {
        XtextEditor editor = this.openEditor("[{|}]");
        this.pressKey(editor, '\n');
        this.assertState("[{\n\t|\n}]", editor);
    }

    @Test
    public void testBug338423_02() throws Exception {
        XtextEditor editor = this.openEditor("[{}|]");
        this.pressKey(editor, '\n');
        this.assertState("[{}\n\t|\n]", editor);
    }

    @Test
    public void testBug358555() throws Exception {
        XtextEditor editor = this.openEditor("/* | /**/");
        this.pressKey(editor, '\n');
        this.assertState("/* \n * | /**/", editor);
    }
}

