/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Definition;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BP2018
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public BP2018(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    private boolean isExtensibilityElement(Element el) {
        boolean isEx = true;
        isEx = isEx && !XMLUtils.equals(el, WSDL_BINDING);
        isEx = isEx && !XMLUtils.equals(el, WSDL_DEFINITIONS);
        isEx = isEx && !XMLUtils.equals(el, WSDL_DOCUMENTATION);
        isEx = isEx && !XMLUtils.equals(el, WSDL_FAULT);
        isEx = isEx && !XMLUtils.equals(el, WSDL_IMPORT);
        isEx = isEx && !XMLUtils.equals(el, WSDL_INPUT);
        isEx = isEx && !XMLUtils.equals(el, WSDL_MESSAGE);
        isEx = isEx && !XMLUtils.equals(el, WSDL_OPERATION);
        isEx = isEx && !XMLUtils.equals(el, WSDL_OUTPUT);
        isEx = isEx && !XMLUtils.equals(el, WSDL_PART);
        isEx = isEx && !XMLUtils.equals(el, WSDL_PORT);
        isEx = isEx && !XMLUtils.equals(el, WSDL_PORTTYPE);
        isEx = isEx && !XMLUtils.equals(el, WSDL_SERVICE);
        isEx = isEx && !XMLUtils.equals(el, WSDL_TYPES);
        return isEx;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        block4: {
            this.result = "passed";
            Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
            try {
                Document doc = this.validator.parseXMLDocumentURL(definition.getDocumentBaseURI(), null);
                Element root = doc.getDocumentElement();
                Element types = XMLUtils.findChildElement(root, WSDL_TYPES);
                if (types == null) break block4;
                Element el = XMLUtils.findPreviousSibling(types);
                while (el != null) {
                    if (!(this.isExtensibilityElement(el) || XMLUtils.equals(el, WSDL_IMPORT) || XMLUtils.equals(el, WSDL_DOCUMENTATION))) {
                        this.result = "failed";
                        String message = "The " + el.getLocalName() + " element must not precede the types element.";
                        this.failureDetail = this.validator.createFailureDetail(message, entryContext);
                        break;
                    }
                    el = XMLUtils.findPreviousSibling(el);
                }
            }
            catch (Throwable t) {
                this.result = "notApplicable";
                this.failureDetail = this.validator.createFailureDetail("An error occurred while processing the document at " + definition.getDocumentBaseURI() + ".\n\n" + Utils.getExceptionDetails(t), entryContext);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

