/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BP1309
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1309(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document doc;
        if (this.validator.isOneWayResponse(entryContext) || (doc = entryContext.getMessageEntryDocument()) == null) {
            this.result = "notApplicable";
        } else {
            NodeList soapEnvList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
            if (soapEnvList == null || soapEnvList.getLength() == 0) {
                this.result = "notApplicable";
            } else {
                try {
                    int n = 0;
                    while (n < soapEnvList.getLength()) {
                        Element soapEnv = (Element)soapEnvList.item(n);
                        NodeList envChildList = soapEnv.getChildNodes();
                        Vector<Element> envChildElemList = new Vector<Element>();
                        int v = 0;
                        while (v < envChildList.getLength()) {
                            Node nextNode = envChildList.item(v);
                            if (nextNode.getNodeType() == 1) {
                                envChildElemList.addElement((Element)nextNode);
                            }
                            ++v;
                        }
                        int m = 0;
                        while (m < envChildElemList.size()) {
                            Element envChildElem = (Element)envChildElemList.elementAt(m);
                            if (envChildElem.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && envChildElem.getLocalName().equals("Body") && envChildElem != envChildElemList.lastElement()) {
                                throw new AssertionFailException(entryContext.getMessageEntry().getMessage());
                            }
                            ++m;
                        }
                        ++n;
                    }
                }
                catch (AssertionFailException e) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

