/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.impl;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.wsi.internal.WSITestToolsEclipseProperties;
import org.eclipse.wst.wsi.internal.WSITestToolsProperties;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.EntryTypeList;
import org.eclipse.wst.wsi.internal.core.profile.ProfileArtifact;
import org.eclipse.wst.wsi.internal.core.profile.ProfileAssertions;
import org.eclipse.wst.wsi.internal.core.profile.ProfileAssertionsReader;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.impl.EntryTypeListImpl;
import org.eclipse.wst.wsi.internal.core.profile.impl.ProfileAssertionsImpl;
import org.eclipse.wst.wsi.internal.core.profile.impl.TestAssertionImpl;
import org.eclipse.wst.wsi.internal.core.util.ArtifactType;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ProfileAssertionsReaderImpl
implements ProfileAssertionsReader {
    protected ProfileAssertions profileAssertions;
    protected TreeMap artifactList = new TreeMap();

    @Override
    public ProfileAssertions readProfileAssertions(String assertionsURI) throws WSIException {
        return this.readProfileAssertions(new InputSource(assertionsURI));
    }

    @Override
    public ProfileAssertions readProfileAssertions(Reader reader) throws WSIException {
        return this.readProfileAssertions(new InputSource(reader));
    }

    private ProfileAssertions readProfileAssertions(InputSource inputSource) throws WSIException {
        this.profileAssertions = new ProfileAssertionsImpl();
        this.artifactList = new TreeMap();
        try {
            try {
                XMLReader reader = XMLUtils.getXMLReader();
                reader.setContentHandler(new ProfileAssertionsHandler());
                if (WSITestToolsProperties.getEclipseContext()) {
                    EntityResolver resolver = new EntityResolver(){

                        @Override
                        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                            URIResolver resolver = WSITestToolsEclipseProperties.getURIResolver();
                            String uri = resolver.resolve("", publicId, systemId);
                            String physicalLocation = resolver.resolvePhysicalLocation("", publicId, uri);
                            InputSource is = null;
                            try {
                                URL url = new URL(physicalLocation);
                                is = new InputSource(uri);
                                is.setByteStream(url.openStream());
                            }
                            catch (Exception exception) {}
                            return is;
                        }
                    };
                    reader.setEntityResolver(resolver);
                }
                reader.parse(inputSource);
            }
            catch (Exception e) {
                throw new WSIException("Could not read and parse profile definition.", e);
            }
        }
        finally {
            if (!Utils.isValidProfileTADVersion(this.profileAssertions)) {
                String tadVersion = this.profileAssertions.getTADVersion();
                if (tadVersion != null) {
                    String tadName = this.profileAssertions.getTADName();
                    throw new WSIException("\nVersion " + tadVersion + " of the \"" + tadName + "\"\n" + "document is not compatible with this version of" + "\n" + "the test tools.");
                }
                throw new WSIException("WS-I validation was unable to run. Unable to read the test assertion document.");
            }
        }
        Iterator it = this.artifactList.keySet().iterator();
        while (it.hasNext()) {
            ProfileArtifact art = (ProfileArtifact)this.artifactList.get(it.next());
            LinkedList res = new LinkedList();
            Iterator it2 = art.getTestAssertionList().iterator();
            while (it2.hasNext()) {
                this.sortTestAssertions(art, (TestAssertion)it2.next(), res);
            }
            art.getTestAssertionList().clear();
            art.getTestAssertionList().addAll(res);
        }
        this.profileAssertions.setArtifactList(this.artifactList);
        return this.profileAssertions;
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public void setLocation(String documentURI) {
    }

    private void sortTestAssertions(ProfileArtifact art, TestAssertion asrt, List list) {
        if (asrt == null || list.contains(asrt)) {
            return;
        }
        if (asrt.getPrereqIdList().isEmpty()) {
            list.add(asrt);
            return;
        }
        for (String id : asrt.getPrereqIdList()) {
            this.sortTestAssertions(art, art.getTestAssertion(id), list);
        }
        list.add(asrt);
    }

    protected boolean alreadyChecked(String id) {
        boolean result = false;
        if (id != null) {
            result = id.equals("BP2110") || id.equals("BP2115") || id.equals("BP2417") || id.equals("BP2114") || id.equals("BP2123") || id.equals("SSBP2209") || id.equals("AP2209") || id.equals("BP2700") || id.equals("BP2011");
        }
        return result;
    }

    class ProfileAssertionsHandler
    extends DefaultHandler {
        private ProfileArtifact artifact;
        private StringBuffer context;
        private StringBuffer assertionDescription;
        private StringBuffer failureMessage;
        private StringBuffer failureDetailDescription;
        private StringBuffer detailDescription;
        private StringBuffer testAssertionId;
        private String currentElement;
        private TestAssertion testAssertion;
        private StringBuffer logInput;
        private StringBuffer wsdlInput;
        private EntryTypeList entryTypeList;

        ProfileAssertionsHandler() {
            this.artifact = ProfileAssertionsReaderImpl.this.profileAssertions.createArtifact();
            this.context = null;
            this.assertionDescription = null;
            this.failureMessage = null;
            this.failureDetailDescription = null;
            this.detailDescription = null;
            this.testAssertionId = null;
            this.currentElement = null;
            this.testAssertion = null;
            this.logInput = null;
            this.wsdlInput = null;
            this.entryTypeList = null;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (namespaceURI != null && (namespaceURI.equals("http://www.ws-i.org/testing/2003/03/assertions/") || namespaceURI.equals("http://www.ws-i.org/testing/2004/07/assertions/"))) {
                this.currentElement = localName;
                if (localName.equals("artifact")) {
                    this.artifact = ProfileAssertionsReaderImpl.this.profileAssertions.createArtifact();
                    this.artifact.setType(ArtifactType.getArtifactType(atts.getValue("type")));
                    ProfileAssertionsReaderImpl.this.artifactList.put(this.artifact.getType().getTypeName(), this.artifact);
                } else if (localName.equals("testAssertion")) {
                    this.testAssertion = new TestAssertionImpl();
                    String id = atts.getValue("", "id");
                    this.testAssertion.setId(id);
                    this.testAssertion.setType(atts.getValue("", "type"));
                    this.testAssertion.setEntryTypeName(atts.getValue("", "entryType"));
                    if (ProfileAssertionsReaderImpl.this.alreadyChecked(id) || !this.testAssertion.getType().equals("required")) {
                        this.testAssertion.setEnabled(false);
                    } else {
                        this.testAssertion.setEnabled(Boolean.valueOf(atts.getValue("", "enabled")));
                    }
                    this.artifact.addTestAssertion(this.testAssertion);
                } else if (localName.equals("context")) {
                    this.context = new StringBuffer();
                } else if (localName.equals("assertionDescription")) {
                    this.assertionDescription = new StringBuffer();
                } else if (localName.equals("failureMessage")) {
                    this.failureMessage = new StringBuffer();
                } else if (localName.equals("failureDetailDescription")) {
                    this.failureDetailDescription = new StringBuffer();
                } else if (localName.equals("detailDescription")) {
                    this.detailDescription = new StringBuffer();
                } else if (localName.equals("testAssertionID")) {
                    this.testAssertionId = new StringBuffer();
                } else if (localName.equals("additionalEntryTypeList")) {
                    this.entryTypeList = new EntryTypeListImpl();
                } else if (localName.equals("messageInput")) {
                    this.logInput = new StringBuffer();
                } else if (localName.equals("wsdlInput")) {
                    this.wsdlInput = new StringBuffer();
                } else if (localName.equals("profileAssertions")) {
                    ProfileAssertionsReaderImpl.this.profileAssertions.setTADName(atts.getValue("", "name"));
                    ProfileAssertionsReaderImpl.this.profileAssertions.setTADVersion(atts.getValue("", "version"));
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qname) {
            if (namespaceURI != null && (namespaceURI.equals("http://www.ws-i.org/testing/2003/03/assertions/") || namespaceURI.equals("http://www.ws-i.org/testing/2004/07/assertions/"))) {
                if (localName.equals("context")) {
                    this.testAssertion.setContext(this.context.toString());
                    this.context = null;
                } else if (localName.equals("assertionDescription")) {
                    this.testAssertion.setAssertionDescription(this.assertionDescription.toString());
                    this.assertionDescription = null;
                } else if (localName.equals("failureMessage")) {
                    this.testAssertion.setFailureMessage(this.failureMessage.toString());
                    this.failureMessage = null;
                } else if (localName.equals("failureDetailDescription")) {
                    this.testAssertion.setFailureDetailDescription(this.failureDetailDescription.toString());
                    this.failureDetailDescription = null;
                } else if (localName.equals("detailDescription")) {
                    this.testAssertion.setDetailDescription(this.detailDescription.toString());
                    this.detailDescription = null;
                } else if (localName.equals("testAssertionID")) {
                    this.testAssertion.addPrereqId(this.testAssertionId.toString());
                    this.testAssertionId = null;
                } else if (localName.equals("additionalEntryTypeList")) {
                    this.testAssertion.setAdditionalEntryTypeList(this.entryTypeList);
                    this.entryTypeList = null;
                } else if (localName.equals("messageInput")) {
                    this.entryTypeList.setLogInput(this.logInput.toString());
                    this.logInput = null;
                } else if (localName.equals("wsdlInput")) {
                    this.entryTypeList.setWSDLInput(this.wsdlInput.toString());
                    this.wsdlInput = null;
                } else {
                    localName.equals("profileAssertions");
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.context != null && this.currentElement.equals("context")) {
                this.context.append(ch, start, length);
            } else if (this.assertionDescription != null && this.currentElement.equals("assertionDescription")) {
                this.assertionDescription.append(ch, start, length);
            } else if (this.failureMessage != null && this.currentElement.equals("failureMessage")) {
                this.failureMessage.append(ch, start, length);
            } else if (this.failureDetailDescription != null && this.currentElement.equals("failureDetailDescription")) {
                this.failureDetailDescription.append(ch, start, length);
            } else if (this.detailDescription != null && this.currentElement.equals("detailDescription")) {
                this.detailDescription.append(ch, start, length);
            } else if (this.testAssertionId != null && this.currentElement.equals("testAssertionID")) {
                this.testAssertionId.append(ch, start, length);
            } else if (this.logInput != null && this.currentElement.equals("messageInput")) {
                this.logInput.append(ch, start, length);
            } else if (this.wsdlInput != null && this.currentElement.equals("wsdlInput")) {
                this.wsdlInput.append(ch, start, length);
            }
        }
    }
}

