/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.tabbed;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNodeWorkingCopy;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.adapters.FSTreeNodeAdapterFactory;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.eclipse.tcf.te.tcf.ui.tabbed.BaseTitledSection;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BasicFolderSection
extends BaseTitledSection {
    private static final DecimalFormat SIZE_FORMAT = new DecimalFormat();
    protected IFSTreeNode node;
    protected IFSTreeNodeWorkingCopy clone;
    protected Text nameText;
    protected Text typeText;
    protected Text locationText;
    protected Text modifiedText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.nameText = this.createTextField(null, Messages.GeneralInformationPage_Name);
        this.typeText = this.createTextField((Control)this.nameText, Messages.GeneralInformationPage_Type);
        this.locationText = this.createWrapTextField((Control)this.typeText, Messages.GeneralInformationPage_Location);
        this.modifiedText = this.createTextField((Control)this.locationText, Messages.GeneralInformationPage_Modified);
    }

    protected void updateInput(IPeerNodeProvider input) {
        Assert.isTrue((boolean)(input instanceof FSTreeNodeAdapterFactory.FSTreeNodePeerNodeProvider));
        this.node = ((FSTreeNodeAdapterFactory.FSTreeNodePeerNodeProvider)input).getFSTreeNode();
        this.clone = this.node.createWorkingCopy();
    }

    public void refresh() {
        SWTControlUtil.setText((Control)this.nameText, (String)(this.clone != null ? this.clone.getName() : ""));
        SWTControlUtil.setText((Control)this.typeText, (String)(this.clone != null ? this.clone.getFileTypeLabel() : ""));
        String location = this.clone == null || this.clone.isRootDirectory() ? Messages.GeneralInformationPage_Computer : this.clone.getLocation();
        SWTControlUtil.setText((Control)this.locationText, (String)location);
        SWTControlUtil.setText((Control)this.modifiedText, (String)(this.clone != null && this.clone.getModificationTime() != 0L ? this.getDateText(this.clone.getModificationTime()) : ""));
        super.refresh();
    }

    protected String getDateText(long time) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
        return dateFormat.format(new Date(time));
    }

    protected String getSizeText(long size) {
        return NLS.bind((String)Messages.GeneralInformationPage_FileSizeInfo, (Object)SIZE_FORMAT.format(size / 1024L), (Object)SIZE_FORMAT.format(size));
    }

    protected String getText() {
        return Messages.BasicFolderSection_BasicInfoText;
    }
}

