/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.project;

import java.util.List;
import org.eclipse.reddeer.eclipse.ui.wizards.WizardPageSettings;
import org.osgi.framework.Version;

public class ProjectSettingValidator {
    private final String pluginId;
    private final String pluginName;
    private final String pluginVersion;
    private final String pluginProvider;
    private final WizardPageSettings wizardPage;
    private final List<String> projectNames;

    public ProjectSettingValidator(String pluginId, String pluginName, String pluginVersion, String pluginProvider, List<String> projectNames, WizardPageSettings wizardPage) {
        this.pluginId = pluginId;
        this.pluginName = pluginName;
        this.pluginVersion = pluginVersion;
        this.pluginProvider = pluginProvider;
        this.projectNames = projectNames;
        this.wizardPage = wizardPage;
    }

    public void validate() {
        this.wizardPage.setPageComplete(true);
        this.wizardPage.setErrorMessage(null);
        if (this.pluginName.trim().length() == 0) {
            this.wizardPage.setErrorMessage("Plugin name cannot be empty!");
            this.wizardPage.setPageComplete(false);
            return;
        }
        if (this.projectNames.contains(this.pluginName)) {
            this.wizardPage.setErrorMessage("A project by that name already exists!");
            this.wizardPage.setPageComplete(false);
            return;
        }
        if (this.pluginId.trim().length() == 0) {
            this.wizardPage.setErrorMessage("Please specify the plugin id.");
            this.wizardPage.setPageComplete(false);
            return;
        }
        if (!this.isValidCompositeID3_0(this.pluginId)) {
            this.wizardPage.setErrorMessage("Invalid plugin id! Legal characters are A-Z a-z 0-9 . _ -");
            this.wizardPage.setPageComplete(false);
            return;
        }
        if (this.pluginProvider.trim().length() == 0) {
            this.wizardPage.setErrorMessage("Please specify plugin provider company.");
            this.wizardPage.setPageComplete(false);
            return;
        }
        try {
            new Version(this.pluginVersion);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.wizardPage.setErrorMessage("The specified version does not have the correct format (major.minor.micro.qualifier) or contains invalid characters!");
            this.wizardPage.setPageComplete(false);
            return;
        }
    }

    private boolean isValidCompositeID3_0(String name) {
        if (name.length() <= 0) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!(c >= 'A' && 'Z' >= c || c >= 'a' && 'z' >= c || c >= '0' && '9' >= c || c == '_' || c == '-' || i != 0 && i != name.length() - 1 && c == '.')) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

