/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.xwt;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.runtime.DisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.xwt.XWTSection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractSectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISection;

public class XWTSectionDescriptor
extends AbstractSectionDescriptor {
    private Section section;
    private View view;
    private DisplayEngine display;

    public XWTSectionDescriptor(Section section, View view, DisplayEngine display) {
        this.section = section;
        this.view = view;
        this.display = display;
    }

    public String getId() {
        return this.section.getName();
    }

    public ISection getSectionClass() {
        return new XWTSection(this.section, this.view, this.display);
    }

    public String getTargetTab() {
        return this.section.getTab().getId();
    }

    public String toString() {
        return "Section " + this.getId();
    }

    public boolean appliesTo(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + System.identityHashCode(this.display);
        result = 31 * result + System.identityHashCode(this.section);
        result = 31 * result + System.identityHashCode(this.view);
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            result = false;
        } else {
            XWTSectionDescriptor other = (XWTSectionDescriptor)((Object)obj);
            result = other.section == this.section && other.view == this.view && other.display == this.display;
        }
        return result;
    }
}

