/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.command.internal;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.command.internal.CommandEventParameter;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class CommandExecutor {
    private static final String LSP_COMMAND_CATEGORY_ID = "org.eclipse.lsp4e.commandCategory";
    private static final String LSP_COMMAND_PARAMETER_TYPE_ID = "org.eclipse.lsp4e.commandParameterType";
    private static final String LSP_PATH_PARAMETER_TYPE_ID = "org.eclipse.lsp4e.pathParameterType";

    public static void executeCommand(@Nullable Command command, @NonNull IDocument document, @Nullable String languageServerId) {
        if (command == null) {
            return;
        }
        if (CommandExecutor.executeCommandServerSide(command, languageServerId, document)) {
            return;
        }
        if (CommandExecutor.executeCommandClientSide(command, document)) {
            return;
        }
        if (command.getArguments() != null) {
            WorkspaceEdit edit = CommandExecutor.createWorkspaceEdit(command.getArguments(), document);
            LSPEclipseUtils.applyWorkspaceEdit(edit);
        }
    }

    private static boolean executeCommandServerSide(@NonNull Command command, @Nullable String languageServerId, @NonNull IDocument document) {
        CompletableFuture<LanguageServer> languageServerFuture;
        block5: {
            if (languageServerId == null) {
                return false;
            }
            LanguageServersRegistry.LanguageServerDefinition languageServerDefinition = LanguageServersRegistry.getInstance().getDefinition(languageServerId);
            if (languageServerDefinition == null) {
                return false;
            }
            try {
                languageServerFuture = CommandExecutor.getLanguageServerForCommand(command, document, languageServerDefinition);
                if (languageServerFuture != null) break block5;
                return false;
            }
            catch (IOException e) {
                LanguageServerPlugin.logError(e);
                return false;
            }
        }
        languageServerFuture.thenAcceptAsync(server -> {
            ExecuteCommandParams params = new ExecuteCommandParams();
            params.setCommand(command.getCommand());
            params.setArguments(command.getArguments());
            server.getWorkspaceService().executeCommand(params);
        });
        return true;
    }

    private static CompletableFuture<LanguageServer> getLanguageServerForCommand(@NonNull Command command, @NonNull IDocument document, @NonNull LanguageServersRegistry.LanguageServerDefinition languageServerDefinition) throws IOException {
        CompletableFuture<LanguageServer> languageServerFuture = LanguageServiceAccessor.getInitializedLanguageServer(document, languageServerDefinition, serverCapabilities -> {
            ExecuteCommandOptions provider = serverCapabilities.getExecuteCommandProvider();
            return provider != null && provider.getCommands().contains(command.getCommand());
        });
        return languageServerFuture;
    }

    private static boolean executeCommandClientSide(@NonNull Command command, @NonNull IDocument document) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return false;
        }
        IPath context = LSPEclipseUtils.toPath(document);
        ParameterizedCommand parameterizedCommand = CommandExecutor.createEclipseCoreCommand(command, context, workbench);
        if (parameterizedCommand == null) {
            return false;
        }
        @Nullable IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
        if (handlerService == null) {
            return false;
        }
        try {
            handlerService.executeCommand(parameterizedCommand, null);
        }
        catch (ExecutionException | NotDefinedException e) {
            LanguageServerPlugin.logError(e);
            return false;
        }
        catch (NotEnabledException | NotHandledException e2) {
            return false;
        }
        return true;
    }

    private static ParameterizedCommand createEclipseCoreCommand(@NonNull Command command, IPath context, @NonNull IWorkbench workbench) {
        String commandId = command.getCommand();
        @Nullable ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
        org.eclipse.core.commands.Command coreCommand = commandService.getCommand(commandId);
        if (!coreCommand.isDefined()) {
            ParameterType commandParamType = commandService.getParameterType(LSP_COMMAND_PARAMETER_TYPE_ID);
            ParameterType pathParamType = commandService.getParameterType(LSP_PATH_PARAMETER_TYPE_ID);
            Category category = commandService.getCategory(LSP_COMMAND_CATEGORY_ID);
            IParameter[] parameters = new IParameter[]{new CommandEventParameter(commandParamType, command.getTitle(), "org.eclipse.lsp4e.command.param"), new CommandEventParameter(pathParamType, command.getTitle(), "org.eclipse.lsp4e.path.param")};
            coreCommand.define(commandId, null, category, parameters);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("org.eclipse.lsp4e.command.param", command);
        parameters.put("org.eclipse.lsp4e.path.param", context);
        ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((org.eclipse.core.commands.Command)coreCommand, parameters);
        return parameterizedCommand;
    }

    private static WorkspaceEdit createWorkspaceEdit(List<Object> commandArguments, IDocument document) {
        WorkspaceEdit res = new WorkspaceEdit();
        HashMap<String, List> changes = new HashMap<String, List>();
        res.setChanges(changes);
        URI initialUri = LSPEclipseUtils.toUri(document);
        Pair currentEntry = new Pair(initialUri, new ArrayList());
        commandArguments.stream().flatMap(item -> {
            if (item instanceof List) {
                return ((List)item).stream();
            }
            return Collections.singleton(item).stream();
        }).forEach(arg -> {
            if (arg instanceof String) {
                changes.put(((URI)pair.key).toString(), (List)pair.value);
                IResource resource = LSPEclipseUtils.findResourceFor((String)arg);
                if (resource != null) {
                    pair.key = resource.getLocationURI();
                    pair.value = new ArrayList();
                }
            } else if (arg instanceof WorkspaceEdit) {
                changes.putAll(((WorkspaceEdit)arg).getChanges());
            } else if (arg instanceof TextEdit) {
                ((List)pair.value).add((TextEdit)arg);
            } else if (arg instanceof Map) {
                Gson gson = new Gson();
                TextEdit edit = (TextEdit)gson.fromJson(gson.toJson(arg), TextEdit.class);
                if (edit != null) {
                    ((List)pair.value).add(edit);
                }
            } else if (arg instanceof JsonPrimitive) {
                JsonPrimitive json = (JsonPrimitive)arg;
                if (json.isString()) {
                    changes.put(((URI)pair.key).toString(), (List)pair.value);
                    IResource resource = LSPEclipseUtils.findResourceFor(json.getAsString());
                    if (resource != null) {
                        pair.key = resource.getLocationURI();
                        pair.value = new ArrayList();
                    }
                }
            } else if (arg instanceof JsonArray) {
                Gson gson = new Gson();
                JsonArray array = (JsonArray)arg;
                array.forEach(elt -> {
                    TextEdit edit = (TextEdit)gson.fromJson(gson.toJson(elt), TextEdit.class);
                    if (edit != null) {
                        ((List)pair.value).add(edit);
                    }
                });
            } else if (arg instanceof JsonObject) {
                Gson gson = new Gson();
                WorkspaceEdit wEdit = (WorkspaceEdit)gson.fromJson((JsonElement)((JsonObject)arg), WorkspaceEdit.class);
                Map entries = wEdit.getChanges();
                if (wEdit != null && !entries.isEmpty()) {
                    changes.putAll(entries);
                } else {
                    TextEdit edit = (TextEdit)gson.fromJson((JsonElement)((JsonObject)arg), TextEdit.class);
                    if (edit != null && edit.getRange() != null) {
                        ((List)pair.value).add(edit);
                    }
                }
            }
        });
        if (!((List)currentEntry.value).isEmpty()) {
            changes.put(((URI)currentEntry.key).toString(), (List)currentEntry.value);
        }
        return res;
    }

    private static final class Pair<K, V> {
        K key;
        V value;

        Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

