/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOException;
import java.util.Arrays;
import org.mapdb.DBException;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.StoreBinary;
import org.mapdb.StoreBinaryGetLong;
import org.mapdb.StoreImmutable;

class IndexTreeListJava {
    static final int maxDirShift = 7;
    static final long full = -1L;
    static final Serializer<long[]> dirSer = new Serializer<long[]>(){

        @Override
        public void serialize(DataOutput2 out, long[] value) throws IOException {
            int len = 2 + 2 * Long.bitCount(value[0]) + 2 * Long.bitCount(value[1]);
            if (len != value.length) {
                throw new DBException.DataCorruption("bitmap!=len");
            }
            out.writeLong(value[0]);
            out.writeLong(value[1]);
            if (value.length == 2) {
                return;
            }
            value = (long[])value.clone();
            long prev = value[3];
            for (int i = 5; i < value.length; i += 2) {
                long old = value[i];
                value[i] = old - prev;
                prev = old;
            }
            out.packLongArray(value, 2, value.length);
        }

        @Override
        public long[] deserialize(DataInput2 in, int available) throws IOException {
            long bitmap1 = in.readLong();
            long bitmap2 = in.readLong();
            int len = 2 + 2 * (Long.bitCount(bitmap1) + Long.bitCount(bitmap2));
            if (len == 2) {
                return IndexTreeListJava.dirEmpty();
            }
            long[] ret = new long[len];
            ret[0] = bitmap1;
            ret[1] = bitmap2;
            in.unpackLongArray(ret, 2, len);
            for (int i = 5; i < ret.length; i += 2) {
                int n = i;
                ret[n] = ret[n] + ret[i - 2];
            }
            return ret;
        }

        @Override
        public boolean isTrusted() {
            return true;
        }
    };
    static final long[] treeRemoveCollapsingTrue = new long[0];

    IndexTreeListJava() {
    }

    static long[] dirEmpty() {
        return new long[2];
    }

    static final int dirOffsetFromSlot(long[] dir, int slot) {
        if (slot > 127) {
            throw new DBException.DataCorruption("slot too high");
        }
        int offset = 0;
        long v = dir[0];
        if (slot > 63) {
            offset += Long.bitCount(v) * 2;
            v = dir[1];
        }
        long mask = (1L << ((slot &= 0x3F) & 0x3F)) - 1L;
        int v2 = (int)(v >>> slot & 1L);
        return -(offset += 2 + Long.bitCount(v & mask) * 2) + (v2 <<= 1) * offset;
    }

    static final int dirOffsetFromLong(long bitmap1, long bitmap2, int slot) {
        if (slot > 127) {
            throw new DBException.DataCorruption("slot too high");
        }
        int offset = 0;
        long v = bitmap1;
        if (slot > 63) {
            offset += Long.bitCount(v) * 2;
            v = bitmap2;
        }
        long mask = (1L << ((slot &= 0x3F) & 0x3F)) - 1L;
        int v2 = (int)(v >>> slot & 1L);
        return -(offset += 2 + Long.bitCount(v & mask) * 2) + (v2 <<= 1) * offset;
    }

    static final long[] dirPut(long[] dir_, int slot, long v1, long v2) {
        int offset = IndexTreeListJava.dirOffsetFromSlot(dir_, slot);
        if (offset < 0) {
            offset = -offset;
            dir_ = Arrays.copyOf(dir_, dir_.length + 2);
            System.arraycopy(dir_, offset, dir_, offset + 2, dir_.length - 2 - offset);
            int bytePos = slot / 64;
            int bitPos = slot % 64;
            dir_[bytePos] = dir_[bytePos] | 1L << bitPos;
        } else {
            dir_ = (long[])dir_.clone();
        }
        dir_[offset] = v1;
        dir_[offset + 1] = v2;
        return dir_;
    }

    static final long[] dirRemove(long[] dir, int slot) {
        int offset = IndexTreeListJava.dirOffsetFromSlot(dir, slot);
        if (offset <= 0) {
            throw new DBException.DataCorruption("offset too low");
        }
        long[] dir2 = new long[dir.length - 2];
        System.arraycopy(dir, 0, dir2, 0, offset);
        System.arraycopy(dir, offset + 2, dir2, offset, dir2.length - offset);
        int bytePos = slot / 64;
        int bitPos = slot % 64;
        dir2[bytePos] = dir2[bytePos] & (1L << bitPos ^ 0xFFFFFFFFFFFFFFFFL);
        return dir2;
    }

    static final long treeGet(int dirShift, long recid2, StoreImmutable store, int level, long index) {
        if (index < 0L) {
            throw new AssertionError();
        }
        if (index >>> level * dirShift != 0L) {
            throw new AssertionError();
        }
        if (dirShift < 0 || dirShift > 7) {
            throw new AssertionError();
        }
        if (!(store instanceof StoreBinary)) {
            return IndexTreeListJava.treeGetNonBinary(dirShift, recid2, store, level, index);
        }
        StoreBinary binStore = (StoreBinary)store;
        return IndexTreeListJava.treeGetBinary(dirShift, recid2, binStore, level, index);
    }

    private static long treeGetBinary(int dirShift, long recid2, StoreBinary binStore, int level, long index) {
        while (level >= 0) {
            int level2;
            StoreBinaryGetLong f;
            long ret;
            if ((ret = binStore.getBinaryLong(recid2, f = (arg_0, arg_1) -> IndexTreeListJava.lambda$treeGetBinary$0(dirShift, level2 = level--, index, arg_0, arg_1))) >= 0L) {
                return ret;
            }
            recid2 = -ret;
        }
        throw new DBException.DataCorruption("Cyclic reference in TreeArrayList");
    }

    private static long treeGetNonBinary(int dirShift, long recid2, StoreImmutable store, int level, long index) {
        while (level >= 0) {
            long[] dir = store.get(recid2, dirSer);
            int dirPos = IndexTreeListJava.dirOffsetFromSlot(dir, IndexTreeListJava.treePos(dirShift, level, index));
            if (dirPos < 0) {
                return 0L;
            }
            recid2 = dir[dirPos];
            if (recid2 == 0L) {
                return 0L;
            }
            long oldIndex = dir[dirPos + 1] - 1L;
            if (oldIndex == index) {
                return recid2;
            }
            if (oldIndex != -1L) {
                return 0L;
            }
            --level;
        }
        throw new DBException.DataCorruption("Cyclic reference in TreeArrayList");
    }

    static final Long treeGetNullable(int dirShift, long recid2, StoreImmutable store, int level, long index) {
        if (index < 0L) {
            throw new AssertionError();
        }
        if (index >>> level * dirShift != 0L) {
            throw new AssertionError();
        }
        if (dirShift < 0 || dirShift > 7) {
            throw new AssertionError();
        }
        while (level >= 0) {
            long[] dir = store.get(recid2, dirSer);
            int dirPos = IndexTreeListJava.dirOffsetFromSlot(dir, IndexTreeListJava.treePos(dirShift, level, index));
            if (dirPos < 0) {
                return null;
            }
            recid2 = dir[dirPos];
            long oldIndex = dir[dirPos + 1] - 1L;
            if (oldIndex != -1L) {
                return oldIndex == index ? Long.valueOf(recid2) : null;
            }
            if (recid2 == 0L) {
                return 0L;
            }
            --level;
        }
        throw new DBException.DataCorruption("Cyclic reference in TreeArrayList");
    }

    protected static int treePos(int dirShift, int level, long index) {
        int shift = dirShift * level;
        return (int)(index >>> shift & (long)((1 << dirShift) - 1));
    }

    static final void treePut(int dirShift, long recid2, Store store, int level, long index, long value) {
        if (index < 0L) {
            throw new AssertionError();
        }
        if (index >>> level * dirShift != 0L) {
            throw new AssertionError();
        }
        while (level >= 0) {
            int slot;
            long[] dir = store.get(recid2, dirSer);
            int dirPos = IndexTreeListJava.dirOffsetFromSlot(dir, slot = IndexTreeListJava.treePos(dirShift, level, index));
            if (dirPos < 0) {
                dir = IndexTreeListJava.dirPut(dir, slot, value, index + 1L);
                store.update(recid2, dir, dirSer);
                return;
            }
            long oldVal = dir[dirPos];
            long oldIndex = dir[dirPos + 1] - 1L;
            if (oldIndex == -1L) {
                if (oldVal == 0L) {
                    throw new AssertionError();
                }
                recid2 = oldVal;
                --level;
                continue;
            }
            if (oldIndex == index) {
                if (oldVal == value) {
                    return;
                }
                dir = (long[])dir.clone();
                dir[dirPos] = value;
                store.update(recid2, dir, dirSer);
            } else {
                dir = (long[])dir.clone();
                dir[dirPos] = IndexTreeListJava.treePutSub(dirShift, store, level - 1, index, value, oldIndex, oldVal);
                dir[dirPos + 1] = 0L;
                store.update(recid2, dir, dirSer);
            }
            return;
        }
        throw new DBException.DataCorruption("level too low");
    }

    static long treePutSub(int dirShift, Store store, int level, long index1, long value1, long index2, long value2) {
        if (level < 0) {
            throw new DBException.DataCorruption("level too low");
        }
        if (dirShift < 0 || dirShift > 7) {
            throw new AssertionError();
        }
        if (index1 >>> (level + 1) * dirShift != index2 >>> (level + 1) * dirShift) {
            throw new DBException.DataCorruption("inconsistent index");
        }
        int pos1 = IndexTreeListJava.treePos(dirShift, level, index1);
        int pos2 = IndexTreeListJava.treePos(dirShift, level, index2);
        long[] dir = IndexTreeListJava.dirEmpty();
        if (pos1 == pos2) {
            long recid2 = IndexTreeListJava.treePutSub(dirShift, store, level - 1, index1, value1, index2, value2);
            dir = IndexTreeListJava.dirPut(dir, pos1, recid2, 0L);
        } else {
            dir = IndexTreeListJava.dirPut(dir, pos1, value1, index1 + 1L);
            dir = IndexTreeListJava.dirPut(dir, pos2, value2, index2 + 1L);
        }
        return store.put(dir, dirSer);
    }

    static boolean treeRemove(int dirShift, long recid2, Store store, int level, long index, Long expectedValue) {
        int slot;
        if (level < 0) {
            throw new DBException.DataCorruption("level too low");
        }
        if (index < 0L) {
            throw new AssertionError();
        }
        if (dirShift < 0 || dirShift > 7) {
            throw new AssertionError();
        }
        long[] dir = store.get(recid2, dirSer);
        int pos = IndexTreeListJava.dirOffsetFromSlot(dir, slot = IndexTreeListJava.treePos(dirShift, level, index));
        if (pos < 0) {
            return false;
        }
        long oldVal = dir[pos];
        long oldIndex = dir[pos + 1] - 1L;
        if (oldIndex == -1L) {
            if (oldVal == 0L) {
                throw new AssertionError();
            }
            return IndexTreeListJava.treeRemove(dirShift, oldVal, store, level - 1, index, expectedValue);
        }
        if (oldIndex == index) {
            if (expectedValue != null && expectedValue != oldVal) {
                return false;
            }
            dir = IndexTreeListJava.dirRemove(dir, slot);
            store.update(recid2, dir, dirSer);
            return true;
        }
        return false;
    }

    static long[] treeRemoveCollapsing(int dirShift, long recid2, Store store, int level, boolean topLevel, long index, Long expectedValue) {
        int slot;
        if (level < 0) {
            throw new DBException.DataCorruption("level too low");
        }
        if (index < 0L) {
            throw new AssertionError();
        }
        if (dirShift < 0 || dirShift > 7) {
            throw new AssertionError();
        }
        long[] dir = store.get(recid2, dirSer);
        int pos = IndexTreeListJava.dirOffsetFromSlot(dir, slot = IndexTreeListJava.treePos(dirShift, level, index));
        if (pos < 0) {
            return null;
        }
        long oldVal = dir[pos];
        long oldIndex = dir[pos + 1] - 1L;
        if (oldIndex == -1L) {
            if (oldVal == 0L) {
                throw new AssertionError();
            }
            long[] result = IndexTreeListJava.treeRemoveCollapsing(dirShift, oldVal, store, level - 1, false, index, expectedValue);
            if (result == null || result == treeRemoveCollapsingTrue) {
                return result;
            }
            if (dir.length == 4 && !topLevel) {
                store.delete(recid2, dirSer);
                return result;
            }
            dir = (long[])dir.clone();
            dir[pos] = result[2];
            dir[pos + 1] = result[3];
            store.update(recid2, dir, dirSer);
            return treeRemoveCollapsingTrue;
        }
        if (oldIndex == index) {
            if (expectedValue != null && expectedValue != oldVal) {
                return null;
            }
            if ((dir = IndexTreeListJava.dirRemove(dir, slot)).length == 4 && dir[3] > 0L) {
                store.delete(recid2, dirSer);
                return dir;
            }
            store.update(recid2, dir, dirSer);
            return treeRemoveCollapsingTrue;
        }
        return null;
    }

    public static long[] treeIter(int dirShift, long recid2, Store store, int level, long indexStart) {
        if (level < 0) {
            throw new DBException.DataCorruption("level too low");
        }
        if (indexStart < 0L) {
            throw new AssertionError();
        }
        if (dirShift < 0 || dirShift > 7) {
            throw new AssertionError();
        }
        long[] dir = store.get(recid2, dirSer);
        boolean first = true;
        int slot = IndexTreeListJava.treePos(dirShift, level, indexStart);
        int pos = IndexTreeListJava.dirOffsetFromSlot(dir, slot);
        if (pos < 0) {
            pos = -pos;
        }
        while (pos < dir.length) {
            block9: {
                block10: {
                    long oldIndex;
                    long oldVal;
                    block7: {
                        block8: {
                            oldVal = dir[pos];
                            oldIndex = dir[pos + 1] - 1L;
                            if (oldIndex != -1L) break block7;
                            if (oldVal != 0L) break block8;
                            first = false;
                            break block9;
                        }
                        long index = first ? indexStart : indexStart & -1L << (level + 1) * dirShift | (long)slot << dirShift * level;
                        long[] ret = IndexTreeListJava.treeIter(dirShift, oldVal, store, level - 1, index);
                        if (ret != null) {
                            return ret;
                        }
                        break block10;
                    }
                    if (oldIndex >= indexStart) {
                        return new long[]{oldIndex, oldVal};
                    }
                }
                first = false;
            }
            pos += 2;
        }
        return null;
    }

    public static <V> V treeFold(long recid2, Store store, int level, V initValue, TreeTraverseCallback<V> callback) {
        if (level < 0) {
            throw new DBException.DataCorruption("level too low");
        }
        long[] dir = store.get(recid2, dirSer);
        for (int pos = 2; pos < dir.length; pos += 2) {
            long oldVal = dir[pos];
            long oldIndex = dir[pos + 1] - 1L;
            if (oldVal == 0L && oldIndex == -1L) continue;
            initValue = oldIndex == -1L ? IndexTreeListJava.treeFold(oldVal, store, level - 1, initValue, callback) : callback.visit(oldIndex, oldVal, initValue);
        }
        return initValue;
    }

    public static void treeClear(long recid2, Store store, int level) {
        IndexTreeListJava.treeClear(recid2, store, level, true);
    }

    private static void treeClear(long recid2, Store store, int level, boolean topLevel) {
        if (level < 0) {
            throw new DBException.DataCorruption("level too low");
        }
        long[] dir = store.get(recid2, dirSer);
        if (topLevel) {
            store.update(recid2, IndexTreeListJava.dirEmpty(), dirSer);
        } else {
            store.delete(recid2, dirSer);
        }
        for (int pos = 2; pos < dir.length; pos += 2) {
            long oldVal = dir[pos];
            long oldIndex = dir[pos + 1] - 1L;
            if (oldIndex != -1L || oldVal == 0L) continue;
            IndexTreeListJava.treeClear(oldVal, store, level - 1, false);
        }
    }

    public static long[] treeLast(long recid2, Store store, int level) {
        if (level < 0) {
            throw new DBException.DataCorruption("level too low");
        }
        long[] dir = store.get(recid2, dirSer);
        for (int pos = dir.length - 2; pos >= 2; pos -= 2) {
            long oldVal = dir[pos];
            long oldIndex = dir[pos + 1] - 1L;
            if (oldVal == 0L && oldIndex == -1L) continue;
            if (oldIndex == -1L) {
                long[] ret = IndexTreeListJava.treeLast(oldVal, store, level - 1);
                if (ret == null) continue;
                return ret;
            }
            return new long[]{oldIndex, oldVal};
        }
        return null;
    }

    private static /* synthetic */ long lambda$treeGetBinary$0(int dirShift, int level2, long index, DataInput2 input, int size) throws IOException {
        long bitmap2;
        long bitmap1 = input.readLong();
        int dirPos = IndexTreeListJava.dirOffsetFromLong(bitmap1, bitmap2 = input.readLong(), IndexTreeListJava.treePos(dirShift, level2, index));
        if (dirPos < 0) {
            return 0L;
        }
        long oldIndex = 0L;
        for (int i = 0; i < (dirPos - 2) / 2; ++i) {
            input.unpackLong();
            oldIndex += input.unpackLong();
        }
        long recid1 = input.unpackLong();
        if (recid1 == 0L) {
            return 0L;
        }
        if ((oldIndex += input.unpackLong() - 1L) == index) {
            return recid1;
        }
        if (oldIndex != -1L) {
            return 0L;
        }
        return -recid1;
    }

    static interface TreeTraverseCallback<V> {
        public V visit(long var1, long var3, V var5);
    }
}

