/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.TripleSources;
import org.eclipse.rdf4j.spin.function.AbstractSpinFunction;

public class HasAllObjects
extends AbstractSpinFunction
implements Function {
    public HasAllObjects() {
        super(SPIF.HAS_ALL_OBJECTS_FUNCTION.stringValue());
    }

    @Override
    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        QueryPreparer qp = this.getCurrentQueryPreparer();
        if (args.length != 3) {
            throw new ValueExprEvaluationException(String.format("%s requires 3 argument, got %d", this.getURI(), args.length));
        }
        Resource subj = (Resource)args[0];
        IRI pred = (IRI)args[1];
        Resource list = (Resource)args[2];
        try {
            CloseableIteration<Value> iter = TripleSources.list(list, qp.getTripleSource());
            while (iter.hasNext()) {
                Value obj = (Value)iter.next();
                if (TripleSources.single(subj, pred, obj, qp.getTripleSource()) != null) continue;
                return BooleanLiteral.FALSE;
            }
        }
        catch (QueryEvaluationException e) {
            throw new ValueExprEvaluationException(e);
        }
        return BooleanLiteral.TRUE;
    }
}

