/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.federated.algebra.FedXZeroLengthPath;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.SimpleBinding;

public class FedXPathIteration
extends LookAheadIteration<BindingSet> {
    private static final String END = "$end_from_path_iteration";
    private static final String START = "$start_from_path_iteration";
    private final EvaluationStrategy strategy;
    private final QueryInfo queryInfo;
    private long currentLength;
    private CloseableIteration<BindingSet> currentIter;
    private final BindingSet bindings;
    private final StatementPattern.Scope scope;
    private final Var startVar;
    private final Var endVar;
    private final boolean startVarFixed;
    private final boolean endVarFixed;
    private final Queue<BindingSet> valueQueue;
    private final Set<BindingSet> reportedValues;
    private final Set<BindingSet> unreportedValues;
    private final TupleExpr pathExpression;
    private final Var contextVar;
    private ValuePair currentVp;
    private static final String JOINVAR_PREFIX = "intermediate_join_";
    private final Set<String> namedIntermediateJoins = new HashSet<String>();
    private final CollectionFactory collectionFactory;
    private static volatile int PATH_ITERATOR_ID_GENERATOR = 0;
    private final int pathIteratorId = PATH_ITERATOR_ID_GENERATOR++;
    private final String endVarName = "END_intermediate_join_" + this.pathIteratorId;

    public FedXPathIteration(EvaluationStrategy strategy, StatementPattern.Scope scope, Var startVar, TupleExpr pathExpression, Var endVar, Var contextVar, long minLength, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        this.strategy = strategy;
        this.scope = scope;
        this.startVar = startVar;
        this.endVar = endVar;
        this.startVarFixed = startVar.hasValue() || bindings.hasBinding(startVar.getName());
        this.endVarFixed = endVar.hasValue() || bindings.hasBinding(endVar.getName());
        this.pathExpression = pathExpression;
        this.contextVar = contextVar;
        this.currentLength = minLength;
        this.bindings = bindings;
        this.collectionFactory = strategy.getCollectionFactory().get();
        this.queryInfo = queryInfo;
        this.reportedValues = this.collectionFactory.createSetOfBindingSets(ValuePair::new, FedXPathIteration::getHas, FedXPathIteration::getGet, FedXPathIteration::getSet);
        this.unreportedValues = this.collectionFactory.createSetOfBindingSets(ValuePair::new, FedXPathIteration::getHas, FedXPathIteration::getGet, FedXPathIteration::getSet);
        this.valueQueue = this.collectionFactory.createBindingSetQueue(ValuePair::new, FedXPathIteration::getHas, FedXPathIteration::getGet, FedXPathIteration::getSet);
        this.createIteration();
    }

    @InternalUseOnly
    public static final BiConsumer<Value, MutableBindingSet> getSet(String s) {
        switch (s) {
            case "$start_from_path_iteration": {
                return (v, vp) -> {
                    ((ValuePair)vp).startValue = v;
                };
            }
            case "$end_from_path_iteration": {
                return (v, vp) -> {
                    ((ValuePair)vp).endValue = v;
                };
            }
        }
        return (v, vp) -> {
            throw new IllegalStateException("A value is being asked to be set where we never expected one");
        };
    }

    public static final Function<BindingSet, Value> getGet(String s) {
        switch (s) {
            case "$start_from_path_iteration": {
                return vp -> ((ValuePair)vp).startValue;
            }
            case "$end_from_path_iteration": {
                return vp -> ((ValuePair)vp).endValue;
            }
        }
        return vp -> {
            throw new IllegalStateException("A value is being asked to be set where we never expected one");
        };
    }

    public static final Predicate<BindingSet> getHas(String s) {
        switch (s) {
            case "$start_from_path_iteration": {
                return vp -> ((ValuePair)vp).startValue != null;
            }
            case "$end_from_path_iteration": {
                return vp -> ((ValuePair)vp).endValue != null;
            }
        }
        return vp -> {
            throw new IllegalStateException("A value is being asked to be set where we never expected one");
        };
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        ValuePair vp;
        QueryBindingSet nextElement;
        block0: while (true) {
            block10: {
                if (this.currentIter != null && !this.currentIter.hasNext()) {
                    this.currentIter.close();
                    this.createIteration();
                    if (this.currentIter != null) continue;
                }
                while (this.currentIter != null) {
                    Value startValue;
                    if (!this.currentIter.hasNext()) return null;
                    BindingSet potentialNextElement = (BindingSet)this.currentIter.next();
                    nextElement = potentialNextElement instanceof QueryBindingSet ? (QueryBindingSet)potentialNextElement : new QueryBindingSet(potentialNextElement);
                    if (!this.startVarFixed && !this.endVarFixed && this.currentVp != null && (startValue = this.currentVp.getStartValue()) != null) {
                        nextElement = new QueryBindingSet(nextElement);
                        this.addBinding(nextElement, this.startVar.getName(), startValue);
                    }
                    if (this.isCyclicPath(vp = this.valuePairFromStartAndEnd(nextElement))) continue block0;
                    if (this.reportedValues.contains(vp)) {
                        if (!this.currentIter.hasNext()) continue block0;
                        continue;
                    }
                    break block10;
                }
                return null;
            }
            if (!this.startVarFixed || !this.endVarFixed) break;
            Value endValue = this.getVarValue(this.endVar, this.endVarFixed, nextElement);
            if (endValue.equals(vp.endValue)) {
                this.add(this.reportedValues, vp);
                if (!vp.startValue.equals(vp.endValue)) {
                    this.addToQueue(this.valueQueue, vp);
                }
                if (!nextElement.hasBinding(this.startVar.getName())) {
                    this.addBinding(nextElement, this.startVar.getName(), vp.startValue);
                }
                if (nextElement.hasBinding(this.endVar.getName())) return this.removeIntermediateJoinVars(nextElement);
                this.addBinding(nextElement, this.endVar.getName(), vp.endValue);
                return this.removeIntermediateJoinVars(nextElement);
            }
            if (!this.add(this.unreportedValues, vp) || vp.startValue.equals(vp.endValue)) continue;
            this.addToQueue(this.valueQueue, vp);
        }
        this.add(this.reportedValues, vp);
        if (!vp.startValue.equals(vp.endValue)) {
            this.addToQueue(this.valueQueue, vp);
        }
        if (!nextElement.hasBinding(this.startVar.getName())) {
            this.addBinding(nextElement, this.startVar.getName(), vp.startValue);
        }
        if (nextElement.hasBinding(this.endVar.getName())) return this.removeIntermediateJoinVars(nextElement);
        this.addBinding(nextElement, this.endVar.getName(), vp.endValue);
        return this.removeIntermediateJoinVars(nextElement);
    }

    private BindingSet removeIntermediateJoinVars(QueryBindingSet nextElement) {
        nextElement.removeAll(this.namedIntermediateJoins);
        return nextElement;
    }

    private ValuePair valuePairFromStartAndEnd(MutableBindingSet nextElement) {
        Value v2;
        Value v1;
        if (this.startVarFixed && this.endVarFixed && this.currentLength > 2L) {
            v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
            v2 = nextElement.getValue(this.endVarName);
        } else if (this.startVarFixed && this.endVarFixed && this.currentLength == 2L) {
            v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
            v2 = nextElement.getValue(this.varNameAtPathLengthOf(this.currentLength - 1L));
        } else {
            v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
            v2 = this.getVarValue(this.endVar, this.endVarFixed, nextElement);
        }
        return new ValuePair(v1, v2);
    }

    private void addBinding(MutableBindingSet bs, String name, Value value) {
        bs.addBinding(name, value);
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        if (this.currentIter != null) {
            this.currentIter.close();
        }
        this.collectionFactory.close();
    }

    protected boolean addToQueue(Queue<BindingSet> valueQueue2, ValuePair vp) throws QueryEvaluationException {
        return valueQueue2.add(vp);
    }

    protected boolean add(Set<BindingSet> valueSet, ValuePair vp) throws QueryEvaluationException {
        return valueSet.add(vp);
    }

    private Value getVarValue(Var var, boolean fixedValue, BindingSet bindingSet) {
        Value v;
        if (fixedValue) {
            v = var.getValue();
            if (v == null) {
                v = this.bindings.getValue(var.getName());
            }
        } else {
            v = bindingSet.getValue(var.getName());
        }
        return v;
    }

    private boolean isCyclicPath(ValuePair vp) {
        if (this.currentLength <= 2L) {
            return false;
        }
        return this.reportedValues.contains(vp);
    }

    private void createIteration() throws QueryEvaluationException {
        if (this.isUnbound(this.startVar, this.bindings) || this.isUnbound(this.endVar, this.bindings)) {
            this.currentIter = null;
        } else if (this.currentLength == 0L) {
            ArrayList<StatementSource> statementSources = new ArrayList<StatementSource>();
            if (this.pathExpression instanceof StatementTupleExpr) {
                statementSources.addAll(((StatementTupleExpr)this.pathExpression).getStatementSources());
            }
            FedXZeroLengthPath zlp = new FedXZeroLengthPath(this.scope, this.startVar.clone(), this.endVar.clone(), this.contextVar != null ? this.contextVar.clone() : null, this.queryInfo, statementSources);
            this.currentIter = this.strategy.evaluate(zlp, this.bindings);
            ++this.currentLength;
        } else if (this.currentLength == 1L) {
            TupleExpr pathExprClone = this.pathExpression.clone();
            if (this.startVarFixed && this.endVarFixed) {
                String varName = this.varNameAtPathLengthOf(this.currentLength);
                Var replacement = this.createAnonVar(varName, null, true);
                VarReplacer replacer = new VarReplacer(this.endVar, replacement, 0L, false);
                pathExprClone.visit(replacer);
            }
            this.currentIter = this.strategy.evaluate(pathExprClone, this.bindings);
            ++this.currentLength;
        } else {
            this.currentVp = (ValuePair)this.valueQueue.poll();
            if (this.currentVp != null) {
                TupleExpr pathExprClone = this.pathExpression.clone();
                if (this.startVarFixed && this.endVarFixed) {
                    Value v = this.currentVp.getEndValue();
                    Var startReplacement = this.createAnonVar(this.varNameAtPathLengthOf(this.currentLength), v, false);
                    Var endReplacement = this.createAnonVar(this.endVarName, null, false);
                    VarReplacer replacer = new VarReplacer(this.startVar, startReplacement, 0L, false);
                    pathExprClone.visit(replacer);
                    replacer = new VarReplacer(this.endVar, endReplacement, 0L, false);
                    pathExprClone.visit(replacer);
                } else {
                    Value v;
                    Var toBeReplaced;
                    if (!this.endVarFixed) {
                        toBeReplaced = this.startVar;
                        v = this.currentVp.getEndValue();
                    } else {
                        toBeReplaced = this.endVar;
                        v = this.currentVp.getStartValue();
                    }
                    String varName = this.varNameAtPathLengthOf(this.currentLength);
                    Var replacement = this.createAnonVar(varName, v, true);
                    VarReplacer replacer = new VarReplacer(toBeReplaced, replacement, 0L, false);
                    pathExprClone.visit(replacer);
                }
                this.currentIter = this.strategy.evaluate(pathExprClone, this.bindings);
            } else {
                this.currentIter = null;
            }
            ++this.currentLength;
        }
    }

    private String varNameAtPathLengthOf(long atLength) {
        return JOINVAR_PREFIX + atLength + "_" + this.pathIteratorId;
    }

    protected boolean isUnbound(Var var, BindingSet bindings) {
        if (var == null) {
            return false;
        }
        return bindings.hasBinding(var.getName()) && bindings.getValue(var.getName()) == null;
    }

    private Var createAnonVar(String varName, Value v, boolean anonymous) {
        this.namedIntermediateJoins.add(varName);
        return Var.of(varName, v, anonymous, false);
    }

    public static class ValuePair
    implements MutableBindingSet {
        private static final long serialVersionUID = 1L;
        private Value startValue;
        private Value endValue;

        public ValuePair() {
        }

        public ValuePair(Value startValue, Value endValue) {
            this.startValue = startValue;
            this.endValue = endValue;
        }

        public Value getStartValue() {
            return this.startValue;
        }

        public Value getEndValue() {
            return this.endValue;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.endValue == null ? 0 : this.endValue.hashCode());
            result = 31 * result + (this.startValue == null ? 0 : this.startValue.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ValuePair)) {
                return false;
            }
            ValuePair other = (ValuePair)obj;
            if (this.endValue == null ? other.endValue != null : !this.endValue.equals(other.endValue)) {
                return false;
            }
            return !(this.startValue == null ? other.startValue != null : !this.startValue.equals(other.startValue));
        }

        @Override
        public Iterator<Binding> iterator() {
            SimpleBinding sb = new SimpleBinding(FedXPathIteration.START, this.startValue);
            SimpleBinding eb = new SimpleBinding(FedXPathIteration.END, this.endValue);
            return List.of(sb, eb).iterator();
        }

        @Override
        public Set<String> getBindingNames() {
            return Set.of(FedXPathIteration.START, FedXPathIteration.END);
        }

        @Override
        public Binding getBinding(String bindingName) {
            switch (bindingName) {
                case "$start_from_path_iteration": {
                    return new SimpleBinding(FedXPathIteration.START, this.startValue);
                }
                case "$end_from_path_iteration": {
                    return new SimpleBinding(FedXPathIteration.END, this.endValue);
                }
            }
            return null;
        }

        @Override
        public boolean hasBinding(String bindingName) {
            switch (bindingName) {
                case "$start_from_path_iteration": {
                    return true;
                }
                case "$end_from_path_iteration": {
                    return false;
                }
            }
            return false;
        }

        @Override
        public Value getValue(String bindingName) {
            switch (bindingName) {
                case "$start_from_path_iteration": {
                    return this.startValue;
                }
                case "$end_from_path_iteration": {
                    return this.endValue;
                }
            }
            return null;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public void addBinding(Binding binding) {
            switch (binding.getName()) {
                case "$start_from_path_iteration": {
                    this.startValue = binding.getValue();
                    break;
                }
                case "$end_from_path_iteration": {
                    this.endValue = binding.getValue();
                }
            }
        }

        @Override
        public void setBinding(String name, Value value) {
            switch (name) {
                case "$start_from_path_iteration": {
                    this.startValue = value;
                    break;
                }
                case "$end_from_path_iteration": {
                    this.endValue = value;
                }
            }
        }

        @Override
        public void setBinding(Binding binding) {
            switch (binding.getName()) {
                case "$start_from_path_iteration": {
                    this.startValue = binding.getValue();
                    break;
                }
                case "$end_from_path_iteration": {
                    this.endValue = binding.getValue();
                }
            }
        }
    }

    private class VarReplacer
    extends AbstractQueryModelVisitor<QueryEvaluationException> {
        private final Var toBeReplaced;
        private final Var replacement;
        private final long index;
        private final boolean replaceAnons;

        public VarReplacer(Var toBeReplaced, Var replacement, long index, boolean replaceAnons) {
            this.toBeReplaced = toBeReplaced;
            this.replacement = replacement;
            this.index = index;
            this.replaceAnons = replaceAnons;
        }

        @Override
        public void meet(Var var) {
            if (this.toBeReplaced.equals(var) || this.toBeReplaced.isAnonymous() && var.isAnonymous() && this.toBeReplaced.hasValue() && this.toBeReplaced.getValue().equals(var.getValue())) {
                QueryModelNode parent = var.getParentNode();
                parent.replaceChildNode(var, this.replacement.clone());
            } else if (this.replaceAnons && var.isAnonymous() && !var.hasValue()) {
                String varName = "anon_replace_" + var.getName() + this.index;
                Var replacementVar = FedXPathIteration.this.createAnonVar(varName, null, true);
                QueryModelNode parent = var.getParentNode();
                parent.replaceChildNode(var, replacementVar);
            }
        }
    }
}

