/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.Objects;
import org.eclipse.rdf4j.rio.RioSetting;

public abstract class AbstractRioSetting<T>
implements RioSetting<T> {
    private static final long serialVersionUID = -7645860224121962271L;
    private final String key;
    private final String description;
    private final T defaultValue;

    protected AbstractRioSetting(String key, String description, T defaultValue) {
        Objects.requireNonNull(key, "Setting key cannot be null");
        Objects.requireNonNull(description, "Setting description cannot be null");
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object other) {
        if (other instanceof RioSetting) {
            RioSetting that = (RioSetting)other;
            return that.getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return this.getKey();
    }
}

